/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.basic;

import com.github.t1.bulmajava.basic.Attribute;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.Renderer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class Attributes
implements Renderable {
    private final List<Attribute> attributes;

    public static Attributes of(Attribute ... attributes) {
        return new Attributes(Stream.of(attributes).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public String toString() {
        return this.render();
    }

    @Override
    public Optional<Renderable> find(Predicate<Renderable> predicate) {
        return this.attributes.stream().filter(predicate).findFirst().map(Renderable.class::cast);
    }

    public boolean hasAttribute(String key, String value) {
        return this.hasAttribute(Attribute.of(key, value));
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.hasAttribute(attribute::matches);
    }

    public boolean hasAttribute(Predicate<Attribute> predicate) {
        return this.findAttribute(predicate).isPresent();
    }

    public Optional<Attribute> findAttribute(Predicate<Attribute> predicate) {
        return this.findAttributes(predicate).findAny();
    }

    public Stream<Attribute> findAttributes(Predicate<Attribute> predicate) {
        return this.attributes.stream().filter(predicate);
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public Attributes add(@NonNull Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        boolean found = false;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute item = this.attributes.get(i);
            if (!item.hasKey(attribute.key())) continue;
            found = true;
            this.attributes.set(i, item.and(attribute));
            break;
        }
        if (!found) {
            this.attributes.add(attribute);
        }
        this.attributes.sort(Attribute.COMPARATOR);
        return this;
    }

    public void remove(Attribute attribute) {
        this.replace(attribute, null);
    }

    public Attributes replace(Attribute existing, Attribute replacement) {
        boolean found = false;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute item = this.attributes.get(i);
            if (!item.hasKey(existing.key())) continue;
            found = true;
            if (replacement == null) {
                this.attributes.remove(i);
                break;
            }
            this.attributes.set(i, replacement);
            break;
        }
        if (!found) {
            throw new IllegalStateException("exiting not found");
        }
        return this;
    }

    @Override
    public void render(Renderer renderer) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i > 0) {
                renderer.unsafeAppend(" ");
            }
            this.attributes.get(i).render(renderer);
        }
    }

    @Generated
    public Attributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attributes)) {
            return false;
        }
        Attributes other = (Attributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Attribute> this$attributes = this.attributes;
        List<Attribute> other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Attributes;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Attribute> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }
}

