/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.basic;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Attribute;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Body;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.Renderer;
import java.net.URI;
import java.util.function.Function;
import lombok.Generated;

public class Html
extends AbstractElement<Html> {
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";

    public static Html html(String title) {
        return new Html(title);
    }

    protected Html(String title) {
        super("html", Attributes.of(Attribute.of("lang", "en")), (Renderable)Basic.element("head").content(Html.meta_("charset", "utf-8"), Html.meta_("http-equiv", "X-UA-Compatible", "IE=edge"), Html.meta_name("viewport", "width=device-width, initial-scale=1"), title == null ? null : Basic.element("title").content(title)));
    }

    public Html meta(String name, String value) {
        return this.head(Html.meta_(name, value));
    }

    public Html metaName(String name, String value) {
        return this.head(Html.meta_name(name, value));
    }

    public Html meta(String name1, String value1, String name2, String value2) {
        return this.head(Html.meta_(name1, value1, name2, value2));
    }

    private static Element meta_(String name, String value) {
        return (Element)((Element)Basic.element("meta").close(false)).attr(name, value);
    }

    private static Element meta_(String name, String value, String content) {
        return Html.meta_(name, value, "content", content);
    }

    private static Element meta_name(String value, String content) {
        return Html.meta_("name", value, "content", content);
    }

    private static Element meta_(String name1, String value1, String name2, String value2) {
        return (Element)Html.meta_(name1, value1).attr(name2, value2);
    }

    public Html title(String title) {
        return this.head((Renderable)Basic.element("title").content(title));
    }

    public Html stylesheet(URI href) {
        return this.stylesheet(href.toString());
    }

    public Html stylesheet(String href) {
        return this.head((Renderable)((Element)((Element)Basic.element("link").attr("rel", "stylesheet")).close(false)).attr("href", href));
    }

    public Html styleElement(String style) {
        return this.head((Renderable)Basic.element("style").content(Renderable.Indented.indented(Renderable.UnsafeString.unsafeString(style))));
    }

    public Html script(URI src) {
        return this.script(src.toString());
    }

    public Html script(String src) {
        return this.head(Body.scriptSrc(src));
    }

    public Html scriptBody(String src) {
        return this.body(Body.scriptSrc(src));
    }

    public Html script(String src, String type) {
        return this.head(Body.scriptSrc(src, type));
    }

    public Html scriptBody(String src, String type) {
        return this.body(Body.scriptSrc(src, type));
    }

    public Html javaScript(String src) {
        return this.script(src, APPLICATION_JAVASCRIPT);
    }

    public Html javaScriptBody(String src) {
        return this.body(Body.scriptSrc(src, APPLICATION_JAVASCRIPT));
    }

    public Html javaScriptCode(String code) {
        return this.body(Body.javaScriptCode(code));
    }

    public Html head(Renderable content) {
        return this.head((AbstractElement<?> e) -> e.content(content));
    }

    public Html head(Function<AbstractElement<?>, AbstractElement<?>> function) {
        return (Html)this.content((AbstractElement<?> e) -> e.hasName("head"), function, () -> Basic.element("head"));
    }

    @Override
    public Html content(Renderable content) {
        AbstractElement e;
        return content instanceof AbstractElement && (e = (AbstractElement)content).hasName("body") ? (Html)super.content(content) : this.body(content);
    }

    public Html body(Renderable content) {
        return this.body((AbstractElement<?> e) -> e.content(content));
    }

    public Html body(Function<AbstractElement<?>, AbstractElement<?>> function) {
        return (Html)this.content((AbstractElement<?> e) -> e.hasName("body"), function, Body::body);
    }

    @Override
    public void render(Renderer renderer) {
        renderer.unsafeAppend("<!DOCTYPE html>\n");
        super.render(renderer);
    }

    @Generated
    protected Html(HtmlBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static HtmlBuilder<?, ?> builder() {
        return new HtmlBuilderImpl();
    }

    @Generated
    public HtmlBuilder<?, ?> toBuilder() {
        return new HtmlBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Html)) {
            return false;
        }
        Html other = (Html)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Html;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class HtmlBuilderImpl
    extends HtmlBuilder<Html, HtmlBuilderImpl> {
        @Generated
        private HtmlBuilderImpl() {
        }

        @Override
        @Generated
        protected HtmlBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Html build() {
            return new Html(this);
        }
    }

    @Generated
    public static abstract class HtmlBuilder<C extends Html, B extends HtmlBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Html, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HtmlBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Html instance, HtmlBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Html.HtmlBuilder(super=" + super.toString() + ")";
        }
    }
}

