/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.basic;

import com.github.t1.bulmajava.basic.Renderer;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Renderable {
    default public <T extends Renderable> Optional<T> find(Class<T> type) {
        return this.find(type::isInstance).map(type::cast);
    }

    default public Optional<Renderable> find(Predicate<Renderable> predicate) {
        return predicate.test(this) ? Optional.of(this) : Optional.empty();
    }

    default public boolean hasClass(String name) {
        return false;
    }

    public void render(Renderer var1);

    default public String render() {
        Renderer renderer = new Renderer();
        this.render(renderer);
        return renderer.render();
    }

    default public void render(OutputStream stream) {
        new PrintStream(stream).append(this.render());
    }

    default public boolean rendersOnSeparateLines() {
        return false;
    }

    public record ConcatenatedRenderable(List<Renderable> renderables) implements Renderable
    {
        public static Collector<Renderable, List<Renderable>, ConcatenatedRenderable> toRenderable() {
            return new Collector<Renderable, List<Renderable>, ConcatenatedRenderable>(){

                @Override
                public Supplier<List<Renderable>> supplier() {
                    return ArrayList::new;
                }

                @Override
                public BiConsumer<List<Renderable>, Renderable> accumulator() {
                    return List::add;
                }

                @Override
                public BinaryOperator<List<Renderable>> combiner() {
                    return (l1, l2) -> {
                        l1.addAll(l2);
                        return l1;
                    };
                }

                @Override
                public Function<List<Renderable>, ConcatenatedRenderable> finisher() {
                    return ConcatenatedRenderable::new;
                }

                @Override
                public Set<Collector.Characteristics> characteristics() {
                    return Set.of();
                }
            };
        }

        public static Renderable concat(Renderable ... renderables) {
            return ConcatenatedRenderable.concat(Stream.of(renderables));
        }

        public static Renderable concat(Stream<Renderable> renderables) {
            return new ConcatenatedRenderable(renderables.flatMap(ConcatenatedRenderable::merge).collect(Collectors.toList()));
        }

        private static Stream<Renderable> merge(Renderable renderable) {
            Stream<Renderable> stream;
            if (renderable instanceof ConcatenatedRenderable) {
                ConcatenatedRenderable concatenatedRenderable = (ConcatenatedRenderable)renderable;
                stream = concatenatedRenderable.renderables.stream();
            } else {
                stream = Stream.of(renderable);
            }
            return stream;
        }

        public ConcatenatedRenderable content(Renderable renderable) {
            this.renderables.add(renderable);
            return this;
        }

        @Override
        public Optional<Renderable> find(Predicate<Renderable> predicate) {
            return this.renderables.stream().filter(predicate).findFirst();
        }

        @Override
        public boolean rendersOnSeparateLines() {
            return this.renderables.stream().anyMatch(Renderable::rendersOnSeparateLines);
        }

        @Override
        public void render(Renderer renderer) {
            this.renderables.forEach(renderable -> {
                if (this.rendersOnSeparateLines() && !renderable.rendersOnSeparateLines()) {
                    renderer.nl().appendIndent();
                }
                renderable.render(renderer);
                if (this.rendersOnSeparateLines() && !renderable.rendersOnSeparateLines()) {
                    renderer.nl();
                }
            });
        }

        public Renderable last() {
            return this.renderables.get(this.renderables.size() - 1);
        }
    }

    public record Indented(Renderable renderable) implements Renderable
    {
        public static Renderable indented(Renderable renderable) {
            return new Indented(renderable);
        }

        @Override
        public void render(Renderer renderer) {
            renderer.nl().in();
            this.renderable.render().lines().forEach(line -> {
                if (!line.isBlank()) {
                    renderer.appendIndent().unsafeAppend((String)line);
                }
                renderer.unsafeAppend("\n");
            });
            renderer.out().appendIndent();
        }
    }

    public record UnsafeString(String string) implements Renderable
    {
        public static Renderable unsafeString(String string) {
            return new UnsafeString(string);
        }

        @Override
        public void render(Renderer renderer) {
            renderer.unsafeAppend(this.string);
        }
    }

    public record RenderableString(String string) implements Renderable
    {
        public static Renderable string(String string) {
            return new RenderableString(string);
        }

        @Override
        public void render(Renderer renderer) {
            renderer.safeAppend(this.string);
        }
    }
}

