/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.basic;

public class Renderer {
    private final StringBuilder string = new StringBuilder();
    private String indentString = "    ";
    private int indent = 0;

    public Renderer indentString(String indentString) {
        this.indentString = indentString;
        return this;
    }

    public Renderer in() {
        ++this.indent;
        return this;
    }

    public Renderer out() {
        --this.indent;
        return this;
    }

    public Renderer appendIndent() {
        return this.unsafeAppend(this.indentString.repeat(this.indent));
    }

    public Renderer nl() {
        if (this.lastChar() != '\n') {
            this.unsafeAppend("\n");
        }
        return this;
    }

    private char lastChar() {
        return this.string.isEmpty() ? (char)'\u0000' : this.string.charAt(this.string.length() - 1);
    }

    public Renderer unsafeAppend(String string) {
        this.string.append(string);
        return this;
    }

    public Renderer safeAppend(String string) {
        if (string != null) {
            string.chars().forEach(this::safeAppend);
        }
        return this;
    }

    private void safeAppend(int c) {
        switch (c) {
            case 38: {
                this.string.append("&amp;");
                break;
            }
            case 60: {
                this.string.append("&lt;");
                break;
            }
            case 62: {
                this.string.append("&gt;");
                break;
            }
            case 34: {
                this.string.append("&quot;");
                break;
            }
            case 39: {
                this.string.append("&#x27;");
                break;
            }
            default: {
                this.string.append((char)c);
            }
        }
    }

    public String render() {
        return this.string.toString();
    }
}

