/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.components;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Anchor;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Classes;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.Size;
import com.github.t1.bulmajava.elements.Button;
import lombok.Generated;

public class Dropdown
extends AbstractElement<Dropdown> {
    public static Dropdown dropdown(String id) {
        return new Dropdown(id, null, "angle-down");
    }

    public static Dropdown dropdown(String buttonTitle, String id) {
        return new Dropdown(id, buttonTitle, "angle-down");
    }

    public static Dropdown dropup(String buttonTitle, String id) {
        return (Dropdown)new Dropdown(id, buttonTitle, "angle-up").classes("is-up");
    }

    private Dropdown(String id, String buttonTitle, String icon) {
        super("div", Attributes.of(Classes.of(new String[]{"dropdown"})), Renderable.ConcatenatedRenderable.concat(Dropdown.trigger(id, buttonTitle, icon), Dropdown.menu(id)));
    }

    private static Element trigger(String id, String buttonTitle, String icon) {
        return (Element)((Element)Basic.div().classes("dropdown-trigger")).content((Renderable)((Button)((Button)Button.button(buttonTitle == null ? null : Basic.span(buttonTitle)).attr("aria-haspopup", "true")).attr("aria-controls", id)).icon(icon, new String[0]).isIcon(Size.SMALL).icon(i -> i.ariaHidden(true)));
    }

    private static Element menu(String id) {
        return (Element)((Element)((Element)((Element)Basic.div().classes("dropdown-menu")).id(id)).attr("role", "menu")).content((Renderable)Basic.div().classes("dropdown-content"));
    }

    @Override
    public Dropdown content(Renderable renderable) {
        this.menu().content(Dropdown.item(renderable));
        return this;
    }

    private Element menu() {
        Renderable.ConcatenatedRenderable triggerAndMenu = this.contentAs(Renderable.ConcatenatedRenderable.class);
        Element menu = (Element)triggerAndMenu.renderables().get(1);
        return menu.contentAs(Element.class);
    }

    private static Renderable item(Renderable renderable) {
        if (renderable instanceof Anchor) {
            Anchor a = (Anchor)renderable;
            return a.classes("dropdown-item");
        }
        if (renderable instanceof Element) {
            Element e = (Element)renderable;
            return e.hasName("hr") ? e.classes("dropdown-divider") : e.classes("dropdown-item");
        }
        return renderable;
    }

    public Button button() {
        return (Button)this.findElement("dropdown-trigger").orElseThrow().findElement("button").orElseThrow();
    }

    @Generated
    protected Dropdown(DropdownBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static DropdownBuilder<?, ?> builder() {
        return new DropdownBuilderImpl();
    }

    @Generated
    public DropdownBuilder<?, ?> toBuilder() {
        return new DropdownBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dropdown)) {
            return false;
        }
        Dropdown other = (Dropdown)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dropdown;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class DropdownBuilderImpl
    extends DropdownBuilder<Dropdown, DropdownBuilderImpl> {
        @Generated
        private DropdownBuilderImpl() {
        }

        @Override
        @Generated
        protected DropdownBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Dropdown build() {
            return new Dropdown(this);
        }
    }

    @Generated
    public static abstract class DropdownBuilder<C extends Dropdown, B extends DropdownBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Dropdown, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DropdownBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Dropdown instance, DropdownBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Dropdown.DropdownBuilder(super=" + super.toString() + ")";
        }
    }
}

