/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.components;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Anchor;
import com.github.t1.bulmajava.basic.Attribute;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Classes;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.Modifier;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.elements.MenuActivationType;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

public class Navbar
extends AbstractElement<Navbar> {
    private String menuId;

    public static Navbar navbar(String menuId) {
        return new Navbar(menuId);
    }

    private Navbar(String menuId) {
        super("nav", Attributes.of(Classes.of(new String[]{"navbar"}), Attribute.of("role", "navigation"), Attribute.of("aria-label", "navigation")));
        this.menuId = menuId;
    }

    private static Renderable item(Renderable renderable) {
        AbstractElement e;
        if (renderable instanceof AbstractElement && !(e = (AbstractElement)renderable).hasClass("navbar-burger")) {
            return e.hasName("hr") ? e.classes("navbar-divider") : e.classes("navbar-item");
        }
        return renderable;
    }

    public static Element navbarStart() {
        return (Element)((Element)Basic.div().classes("navbar-start")).map(Navbar::item);
    }

    public Navbar brand(Renderable ... renderables) {
        return this.content((Renderable)((Element)((Element)Basic.div().classes("navbar-brand")).map(Navbar::item)).content(renderables));
    }

    public Navbar burger() {
        this.findElement("navbar-brand").orElseThrow().content((Renderable)Navbar.navbarBurger(this.menuId));
        return this;
    }

    private static Anchor navbarBurger(String targetId) {
        Anchor burger = (Anchor)((Anchor)((Anchor)((Anchor)((Anchor)Anchor.a().classes("navbar-burger")).attr("role", "button")).ariaLabel("menu")).attr("aria-expanded", "false")).content(new Renderable[]{Basic.span().ariaHidden(true), Basic.span().ariaHidden(true), Basic.span().ariaHidden(true)});
        if (targetId != null) {
            burger = (Anchor)burger.attr("data-target", targetId);
        }
        return burger;
    }

    @Override
    @Deprecated
    public Navbar content(String content) {
        return (Navbar)super.content(content);
    }

    @Override
    @Deprecated
    public Navbar content(Stream<? extends Renderable> content) {
        return (Navbar)super.content(content);
    }

    @Override
    @Deprecated
    public Navbar content(Renderable ... content) {
        return (Navbar)super.content(content);
    }

    @Override
    @Deprecated
    public Navbar content(Renderable content) {
        return (Navbar)super.content(content);
    }

    public Navbar isFixedTop() {
        return (Navbar)this.classes("is-fixed-top");
    }

    public Navbar isFixedBottom() {
        return (Navbar)this.classes("is-fixed-bottom");
    }

    public Navbar isTransparent() {
        return (Navbar)this.classes("is-transparent");
    }

    public Navbar start(Renderable ... newStartContent) {
        AbstractElement menu = this.findElement("navbar-menu").orElseGet(this::navbarMenu);
        return this.content((Renderable)menu.content((Renderable)Navbar.navbarStart().content(newStartContent)));
    }

    public Navbar end(Renderable ... newEndContent) {
        Element menu = this.getOrCreate("navbar-menu", this::navbarMenu);
        Element end = menu.getOrCreate("navbar-end", () -> (Element)Basic.div().map(Navbar::item));
        end.content(newEndContent);
        return this;
    }

    private Element navbarMenu() {
        return (Element)((Element)Basic.div().classes("navbar-menu")).id(this.menuId);
    }

    @Generated
    protected Navbar(NavbarBuilder<?, ?> b) {
        super(b);
        this.menuId = b.menuId;
    }

    @Generated
    public static NavbarBuilder<?, ?> builder() {
        return new NavbarBuilderImpl();
    }

    @Generated
    public NavbarBuilder<?, ?> toBuilder() {
        return new NavbarBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Navbar)) {
            return false;
        }
        Navbar other = (Navbar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$menuId = this.menuId;
        String other$menuId = other.menuId;
        return !(this$menuId == null ? other$menuId != null : !this$menuId.equals(other$menuId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Navbar;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $menuId = this.menuId;
        result = result * 59 + ($menuId == null ? 43 : $menuId.hashCode());
        return result;
    }

    @Generated
    public static abstract class NavbarBuilder<C extends Navbar, B extends NavbarBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Navbar, C, B> {
        @Generated
        private String menuId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NavbarBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Navbar instance, NavbarBuilder<?, ?> b) {
            b.menuId(instance.menuId);
        }

        @Generated
        public B menuId(String menuId) {
            this.menuId = menuId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Navbar.NavbarBuilder(super=" + super.toString() + ", menuId=" + this.menuId + ")";
        }
    }

    @Generated
    private static final class NavbarBuilderImpl
    extends NavbarBuilder<Navbar, NavbarBuilderImpl> {
        @Generated
        private NavbarBuilderImpl() {
        }

        @Override
        @Generated
        protected NavbarBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Navbar build() {
            return new Navbar(this);
        }
    }

    public static class NavbarDropdown
    extends AbstractElement<NavbarDropdown> {
        public static NavbarDropdown navbarDropdown(String dropdownName, MenuActivationType activationType) {
            return (NavbarDropdown)new NavbarDropdown().is(activationType).content(new Renderable[]{Anchor.a(dropdownName).classes("navbar-link"), ((Element)Basic.div().classes("navbar-dropdown")).map(Navbar::item)});
        }

        private NavbarDropdown() {
            super("div", "has-dropdown");
        }

        @Override
        public NavbarDropdown content(Renderable content) {
            Optional<AbstractElement<?>> dropdown = this.findDropdown();
            if (dropdown.isPresent()) {
                dropdown.get().content(Navbar.item(content));
                return this;
            }
            return (NavbarDropdown)super.content(content);
        }

        private Optional<AbstractElement<?>> findDropdown() {
            return this.findElement("navbar-dropdown");
        }

        private Optional<AbstractElement<?>> findLink() {
            return this.findElement("navbar-link");
        }

        @Override
        public NavbarDropdown is(Modifier ... modifiers) {
            for (Modifier modifier : modifiers) {
                if (modifier instanceof MenuActivationType) {
                    this.classes(modifier.className());
                    continue;
                }
                this.findDropdown().orElseThrow().classes(modifier.className());
            }
            return this;
        }

        public NavbarDropdown arrowless() {
            AbstractElement<?> link = this.findLink().orElseThrow();
            link.classes("is-arrowless");
            return this;
        }

        @Generated
        protected NavbarDropdown(NavbarDropdownBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static NavbarDropdownBuilder<?, ?> builder() {
            return new NavbarDropdownBuilderImpl();
        }

        @Generated
        public NavbarDropdownBuilder<?, ?> toBuilder() {
            return new NavbarDropdownBuilderImpl().$fillValuesFrom(this);
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NavbarDropdown)) {
                return false;
            }
            NavbarDropdown other = (NavbarDropdown)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NavbarDropdown;
        }

        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        private static final class NavbarDropdownBuilderImpl
        extends NavbarDropdownBuilder<NavbarDropdown, NavbarDropdownBuilderImpl> {
            @Generated
            private NavbarDropdownBuilderImpl() {
            }

            @Override
            @Generated
            protected NavbarDropdownBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public NavbarDropdown build() {
                return new NavbarDropdown(this);
            }
        }

        @Generated
        public static abstract class NavbarDropdownBuilder<C extends NavbarDropdown, B extends NavbarDropdownBuilder<C, B>>
        extends AbstractElement.AbstractElementBuilder<NavbarDropdown, C, B> {
            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                NavbarDropdownBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(NavbarDropdown instance, NavbarDropdownBuilder<?, ?> b) {
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "Navbar.NavbarDropdown.NavbarDropdownBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

