/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.components;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Anchor;
import com.github.t1.bulmajava.basic.Attribute;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Classes;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.Renderable;
import lombok.Generated;

public class Pagination
extends AbstractElement<Pagination> {
    private final int min;
    private final int current;
    private final int max;

    public static Pagination pagination(int min, int current, int max) {
        return new Pagination(min, current, max);
    }

    public Pagination(int min, int current, int max) {
        super("nav", Attributes.of(Classes.of(new String[]{"pagination"}), Attribute.of("role", "navigation"), Attribute.of("aria-label", "pagination")));
        if (current < min) {
            throw new IllegalArgumentException("current value " + current + " is below minimum " + min);
        }
        if (current > max) {
            throw new IllegalArgumentException("current value " + current + " is above maximum " + max);
        }
        this.min = min;
        this.current = current;
        this.max = max;
    }

    public Pagination previous(String label) {
        Anchor link = (Anchor)Anchor.a(label).classes("pagination-previous");
        if (this.current <= this.min) {
            link = (Anchor)link.classes("is-disabled");
        }
        return (Pagination)this.content((Renderable)link);
    }

    public Pagination next(String label) {
        Anchor link = (Anchor)Anchor.a(label).classes("pagination-next");
        if (this.current >= this.max) {
            link = (Anchor)link.classes("is-disabled");
        }
        return (Pagination)this.content((Renderable)link);
    }

    public Pagination pages() {
        Element list = (Element)Basic.ul().classes("pagination-list");
        if (this.min < this.current) {
            list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Anchor)Anchor.a(Integer.toString(this.min)).classes("pagination-link")).ariaLabel("Goto page " + this.min)));
        }
        if (this.current - this.min > 2) {
            list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Element)Basic.span().classes("pagination-ellipsis")).content(Renderable.UnsafeString.unsafeString("&hellip;"))));
        }
        if (this.current - this.min > 1) {
            list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Anchor)Anchor.a(Integer.toString(this.current - 1)).classes("pagination-link")).ariaLabel("Goto page " + (this.current - 1))));
        }
        list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Anchor)((Anchor)Anchor.a(Integer.toString(this.current)).classes("pagination-link", "is-current")).ariaLabel("Page " + this.current)).active()));
        if (this.max - this.current > 1) {
            list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Anchor)Anchor.a(Integer.toString(this.current + 1)).classes("pagination-link")).ariaLabel("Goto page " + (this.current + 1))));
        }
        if (this.max - this.current > 2) {
            list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Element)Basic.span().classes("pagination-ellipsis")).content(Renderable.UnsafeString.unsafeString("&hellip;"))));
        }
        if (this.current != this.max) {
            list = (Element)list.content((Renderable)Basic.li().content((Renderable)((Anchor)Anchor.a(Integer.toString(this.max)).classes("pagination-link")).ariaLabel("Goto page " + this.max)));
        }
        return (Pagination)this.content((Renderable)list);
    }

    @Generated
    protected Pagination(PaginationBuilder<?, ?> b) {
        super(b);
        this.min = b.min;
        this.current = b.current;
        this.max = b.max;
    }

    @Generated
    public static PaginationBuilder<?, ?> builder() {
        return new PaginationBuilderImpl();
    }

    @Generated
    public PaginationBuilder<?, ?> toBuilder() {
        return new PaginationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (this.current != other.current) {
            return false;
        }
        return this.max == other.max;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.min;
        result = result * 59 + this.current;
        result = result * 59 + this.max;
        return result;
    }

    @Generated
    public static abstract class PaginationBuilder<C extends Pagination, B extends PaginationBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Pagination, C, B> {
        @Generated
        private int min;
        @Generated
        private int current;
        @Generated
        private int max;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PaginationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Pagination instance, PaginationBuilder<?, ?> b) {
            b.min(instance.min);
            b.current(instance.current);
            b.max(instance.max);
        }

        @Generated
        public B min(int min) {
            this.min = min;
            return (B)this.self();
        }

        @Generated
        public B current(int current) {
            this.current = current;
            return (B)this.self();
        }

        @Generated
        public B max(int max) {
            this.max = max;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Pagination.PaginationBuilder(super=" + super.toString() + ", min=" + this.min + ", current=" + this.current + ", max=" + this.max + ")";
        }
    }

    @Generated
    private static final class PaginationBuilderImpl
    extends PaginationBuilder<Pagination, PaginationBuilderImpl> {
        @Generated
        private PaginationBuilderImpl() {
        }

        @Override
        @Generated
        protected PaginationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Pagination build() {
            return new Pagination(this);
        }
    }
}

