/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.elements;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.FontSize;
import com.github.t1.bulmajava.basic.Modifier;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.elements.ButtonType;
import com.github.t1.bulmajava.elements.Icon;
import java.util.Locale;
import java.util.function.Function;
import lombok.Generated;

public class Button
extends AbstractElement<Button> {
    public static Element buttons() {
        return (Element)Basic.div().classes("buttons");
    }

    public static Element fieldsAddon() {
        return (Element)((Element)Basic.div().classes("field", "has-addons")).map(Button::inControl);
    }

    private static Renderable inControl(Renderable renderable) {
        return renderable.hasClass("control") ? renderable : Basic.control().content(renderable);
    }

    public static Element buttonsAddon() {
        return (Element)Button.buttons().classes("has-addons");
    }

    public static Button button(String content) {
        return Button.button(Renderable.RenderableString.string(content));
    }

    public static Button button(Renderable content) {
        return (Button)Button.button().content(content);
    }

    public static Button button() {
        return new Button();
    }

    private Button() {
        super("button", "button");
    }

    public Button responsive() {
        return (Button)this.is(() -> "responsive");
    }

    public Button submit() {
        return (Button)this.attr("type", "submit");
    }

    public Button icon(String name, String ... classes) {
        return this.icon(name, (FontSize)null, classes);
    }

    public Button icon(String name, FontSize fontSize, String ... classes) {
        this.content((Renderable)Icon.icon(name, fontSize, classes));
        return this;
    }

    public Button icon(Function<Icon, Icon> function) {
        Icon existing = this.content().find(Icon.class).orElseThrow(() -> new IllegalStateException("no icon found"));
        function.apply(existing);
        return this;
    }

    public Button isIcon(Modifier ... modifiers) {
        return this.icon(icon -> icon.is(modifiers));
    }

    public Button type(ButtonType buttonType) {
        return (Button)this.attr("type", buttonType.name().toLowerCase(Locale.ROOT));
    }

    @Generated
    protected Button(ButtonBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static ButtonBuilder<?, ?> builder() {
        return new ButtonBuilderImpl();
    }

    @Generated
    public ButtonBuilder<?, ?> toBuilder() {
        return new ButtonBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Button)) {
            return false;
        }
        Button other = (Button)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Button;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class ButtonBuilderImpl
    extends ButtonBuilder<Button, ButtonBuilderImpl> {
        @Generated
        private ButtonBuilderImpl() {
        }

        @Override
        @Generated
        protected ButtonBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Button build() {
            return new Button(this);
        }
    }

    @Generated
    public static abstract class ButtonBuilder<C extends Button, B extends ButtonBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Button, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ButtonBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Button instance, ButtonBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Button.ButtonBuilder(super=" + super.toString() + ")";
        }
    }
}

