/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.elements;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Color;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.FontSize;
import com.github.t1.bulmajava.basic.Modifier;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.Size;
import com.github.t1.bulmajava.elements.IconSize;
import com.github.t1.bulmajava.elements.IconStyle;
import java.util.function.Function;
import lombok.Generated;

public class Icon
extends AbstractElement<Icon> {
    public static Icon icon(String name, String ... classes) {
        return Icon.icon(name, (FontSize)null, classes);
    }

    public static Icon icon(String name, IconStyle style, String ... classes) {
        return Icon.icon(name, style, null, classes);
    }

    public static Icon icon(String name, FontSize fontSize, String ... classes) {
        return Icon.icon(name, IconStyle.SOLID, fontSize, classes);
    }

    public static Icon icon(String name, IconStyle style, FontSize fontSize, String ... classes) {
        return ((Icon)new Icon().content((Renderable)((Element)Basic.i().classes(style.className(), "fa-" + name)).classes(classes))).fontSize(fontSize);
    }

    public static Element iconStack(Icon ... icons) {
        Element stack = (Element)Basic.span().classes("fa-stack fa-lg");
        for (int i = 0; i < icons.length; ++i) {
            stack = (Element)stack.content((Renderable)icons[i].getI().classes("fa-stack-" + (i + 1) + "x"));
        }
        return (Element)((Element)((Element)Basic.span().classes("icon")).is(Size.LARGE)).content((Renderable)stack);
    }

    private AbstractElement<?> getI() {
        return (AbstractElement)this.content();
    }

    public static Element iconText() {
        return (Element)Basic.span().classes("icon-text");
    }

    public static Element iconTextFlex() {
        return (Element)Basic.div().classes("icon-text");
    }

    private Icon() {
        super("span", "icon");
    }

    @Override
    public Icon ariaHidden(boolean hidden) {
        this.withI(e -> (Element)e.ariaHidden(hidden));
        return this;
    }

    @Override
    public Icon is(Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            if (modifier instanceof IconSize) {
                this.withI(i -> (Element)i.is(modifier));
                continue;
            }
            if (modifier instanceof Color) {
                this.withI(i -> (Element)i.hasText(modifier));
                continue;
            }
            if (modifier instanceof Size) {
                ((Icon)this.notClasses(Size.SMALL.className())).classes(modifier.className());
                continue;
            }
            this.classes(modifier.className());
        }
        return this;
    }

    private Icon fontSize(FontSize fontSize) {
        if (fontSize != null) {
            this.withI(i -> (Element)i.classes("fa-" + fontSize.code()));
        }
        return this;
    }

    private void withI(Function<Element, Element> function) {
        function.apply(this.contentAs(Element.class));
    }

    @Generated
    protected Icon(IconBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static IconBuilder<?, ?> builder() {
        return new IconBuilderImpl();
    }

    @Generated
    public IconBuilder<?, ?> toBuilder() {
        return new IconBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Icon)) {
            return false;
        }
        Icon other = (Icon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Icon;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class IconBuilderImpl
    extends IconBuilder<Icon, IconBuilderImpl> {
        @Generated
        private IconBuilderImpl() {
        }

        @Override
        @Generated
        protected IconBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Icon build() {
            return new Icon(this);
        }
    }

    @Generated
    public static abstract class IconBuilder<C extends Icon, B extends IconBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Icon, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            IconBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Icon instance, IconBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Icon.IconBuilder(super=" + super.toString() + ")";
        }
    }
}

