/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.elements;

import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.Modifier;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.elements.ImageDimension;
import com.github.t1.bulmajava.elements.ImageRatio;

public class Image {
    public static Element iframe(String src, Modifier ... modifiers) {
        return (Element)((Element)Basic.element("iframe").is(modifiers)).attr("src", src);
    }

    public static Element image(ImageDimension dimension, String src, String alt, Modifier ... modifiers) {
        return (Element)Image.image(dimension).content((Renderable)Image.img(src, alt, modifiers));
    }

    public static Element image(ImageDimension dimension) {
        return (Element)((Element)Image.figure().classes("image")).classes(dimension.className());
    }

    public static Element imageP(ImageDimension dimension) {
        return (Element)((Element)Basic.p().classes("image")).classes(dimension.className());
    }

    public static Element img(String src, String alt, String width, String height, Modifier ... modifiers) {
        return (Element)((Element)Image.img(src, alt, modifiers).attr("width", width)).attr("height", height);
    }

    public static Element img(String src, String alt, Modifier ... modifiers) {
        Element img = (Element)((Element)((Element)Basic.element("img").close(false)).is(modifiers)).attr("src", src);
        if (alt != null) {
            img = (Element)img.attr("alt", alt);
        }
        return img;
    }

    public static Element movie(ImageRatio ratio, String src, String width, String height, Modifier ... modifiers) {
        return (Element)Image.image(ratio).content((Renderable)((Element)((Element)((Element)Image.iframe(src, modifiers).classes("has-ratio")).attr("width", width)).attr("height", height)).attr("allowfullscreen"));
    }

    public static Element figure() {
        return Basic.element("figure");
    }
}

