/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.form;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Attribute;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Classes;
import com.github.t1.bulmajava.form.InputType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

public class Input
extends AbstractElement<Input> {
    public static Input submit(String value) {
        return Input.inputButton(InputType.SUBMIT, value);
    }

    public static Input reset(String value) {
        return Input.inputButton(InputType.RESET, value);
    }

    private static Input inputButton(InputType type, String value) {
        return (Input)((Input)Input.input(type).value(value).notClasses("input")).classes("button");
    }

    public static Input input(InputType type) {
        return (Input)new Input(type).close(false);
    }

    private Input(InputType type) {
        super("input", Attributes.of(Classes.of(new String[]{"input"}), Attribute.of("type", type.key())));
    }

    public Input value(int value) {
        return this.value(Integer.toString(value));
    }

    public Input value(String value) {
        return value == null ? this : (Input)this.attr("value", value);
    }

    public Input placeholder(String placeholder) {
        return (Input)this.attr("placeholder", placeholder);
    }

    public Input name(String name) {
        return (Input)this.attr("name", name);
    }

    public Input readonly() {
        return (Input)this.attr("readonly");
    }

    public Input readonly(boolean readonly) {
        return readonly ? this.readonly() : this;
    }

    public Input required() {
        return (Input)this.attr("required");
    }

    public Input required(boolean required) {
        return required ? this.required() : this;
    }

    public Input minlength(int minlength) {
        return (Input)this.attr("minlength", Integer.toString(minlength));
    }

    public Input maxlength(int maxlength) {
        return (Input)this.attr("maxlength", Integer.toString(maxlength));
    }

    public Input min(LocalDate localDate) {
        return (Input)this.attr("min", localDate.format(DateTimeFormatter.ISO_DATE));
    }

    public Input min(int min) {
        return (Input)this.attr("min", Integer.toString(min));
    }

    public Input max(LocalDate localDate) {
        return (Input)this.attr("max", localDate.format(DateTimeFormatter.ISO_DATE));
    }

    public Input max(int max) {
        return (Input)this.attr("max", Integer.toString(max));
    }

    public Input step(int step) {
        return (Input)this.attr("step", Integer.toString(step));
    }

    @Generated
    protected Input(InputBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static InputBuilder<?, ?> builder() {
        return new InputBuilderImpl();
    }

    @Generated
    public InputBuilder<?, ?> toBuilder() {
        return new InputBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Input)) {
            return false;
        }
        Input other = (Input)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Input;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class InputBuilderImpl
    extends InputBuilder<Input, InputBuilderImpl> {
        @Generated
        private InputBuilderImpl() {
        }

        @Override
        @Generated
        protected InputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Input build() {
            return new Input(this);
        }
    }

    @Generated
    public static abstract class InputBuilder<C extends Input, B extends InputBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Input, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            InputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Input instance, InputBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Input.InputBuilder(super=" + super.toString() + ")";
        }
    }
}

