/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.form;

import com.github.t1.bulmajava.basic.AbstractElement;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Classes;
import com.github.t1.bulmajava.basic.Element;
import com.github.t1.bulmajava.basic.Modifier;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.State;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

public class Select
extends AbstractElement<Select> {
    private static final Function<Select, Element> CONTENT_ELEMENT = select -> select.contentAs(Element.class);

    public static Select select(String name) {
        return new Select(name);
    }

    private Select(String name) {
        super("div", Attributes.of(Classes.of(new String[]{"select"})), Select.selectElement(name));
    }

    private static Element selectElement(String name) {
        Element select = Basic.element("select");
        if (name != null) {
            select = (Element)select.attr("name", name);
        }
        return select;
    }

    public Select options(Stream<String> options) {
        options.forEach(this::option);
        return this;
    }

    public Select options(String ... options) {
        return this.options(Arrays.stream(options));
    }

    public Select options(Collection<String> options) {
        return this.options(options.stream());
    }

    public Select option(String text) {
        return this.option(text, text);
    }

    public Select option(String value, String text) {
        Element option = Basic.element("option");
        if (value != null) {
            option = (Element)option.attr("value", value);
        }
        this.contentAs(Element.class).content((Renderable)option.content(text));
        return this;
    }

    @Override
    @Deprecated
    public Select content(String content) {
        return (Select)super.content(content);
    }

    @Override
    @Deprecated
    public Select content(Renderable content) {
        throw new UnsupportedOperationException("select elements can only contain options");
    }

    @Override
    @Deprecated
    public Select content(Renderable ... content) {
        return (Select)super.content(content);
    }

    @Override
    @Deprecated
    public Select content(Stream<? extends Renderable> content) {
        return (Select)super.content(content);
    }

    public Select selected() {
        this.lastOption().attr("selected");
        return this;
    }

    private Element lastOption() {
        Element contentElement = this.contentAs(Element.class);
        return (Element)(contentElement.contentIsA(Renderable.ConcatenatedRenderable.class) ? contentElement.contentAs(Renderable.ConcatenatedRenderable.class).last() : contentElement.content());
    }

    public Select multiple(int size) {
        this.multiple();
        this.contentAs(Element.class).attr("size", Integer.toString(size));
        return this;
    }

    public Select multiple() {
        this.contentAs(Element.class).attr("multiple");
        return (Select)this.classes("is-multiple");
    }

    @Override
    public Select is(Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            if (modifier instanceof State && modifier != State.LOADING) {
                this.withS(i -> (Element)i.is(modifier));
                continue;
            }
            this.classes(modifier.className());
        }
        return this;
    }

    private void withS(Function<Element, Element> function) {
        function.apply(this.contentAs(Element.class));
    }

    @Generated
    protected Select(SelectBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static SelectBuilder<?, ?> builder() {
        return new SelectBuilderImpl();
    }

    @Generated
    public SelectBuilder<?, ?> toBuilder() {
        return new SelectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Select)) {
            return false;
        }
        Select other = (Select)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Select;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class SelectBuilderImpl
    extends SelectBuilder<Select, SelectBuilderImpl> {
        @Generated
        private SelectBuilderImpl() {
        }

        @Override
        @Generated
        protected SelectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Select build() {
            return new Select(this);
        }
    }

    @Generated
    public static abstract class SelectBuilder<C extends Select, B extends SelectBuilder<C, B>>
    extends AbstractElement.AbstractElementBuilder<Select, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SelectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Select instance, SelectBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Select.SelectBuilder(super=" + super.toString() + ")";
        }
    }
}

