/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.logging.clientfilter;

import com.github.t1.logging.clientfilter.LoggingTools;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogWrapper
extends AutoCloseable {
    public static LogWrapper of(String loggerName) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger.isDebugEnabled()) {
            return new StandardLogWrapper(logger);
        }
        Logger singleLogger;
        while (!(singleLogger = LoggerFactory.getLogger((String)(loggerName + "..single"))).isDebugEnabled()) {
            if (loggerName.isEmpty()) {
                return new OffLogWrapper();
            }
            int lastDot = loggerName.lastIndexOf(46);
            loggerName = lastDot < 0 ? "" : loggerName.substring(0, lastDot);
        }
        return new SingleLogWrapper(singleLogger);
    }

    default public boolean off() {
        return false;
    }

    public void debug(String var1, Object ... var2);

    public void warn(String var1, Object ... var2);

    @Override
    default public void close() {
    }

    public static class StandardLogWrapper
    implements LogWrapper {
        private final Logger logger;

        StandardLogWrapper(Logger logger) {
            assert (logger.isDebugEnabled());
            this.logger = logger;
        }

        public String toString() {
            return "STANDARD:" + this.logger.getName();
        }

        @Override
        public void debug(String message, Object ... args) {
            this.logger.debug(message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            this.logger.warn(message, args);
        }
    }

    public static class SingleLogWrapper
    implements LogWrapper {
        private final Logger logger;
        private final StringBuilder buffer = new StringBuilder();
        private boolean closed = false;

        SingleLogWrapper(Logger logger) {
            assert (logger.isDebugEnabled());
            this.logger = logger;
        }

        public String toString() {
            return "SINGLE:" + this.logger.getName();
        }

        @Override
        public void debug(String message, Object ... args) {
            this.checkNotClosed();
            LoggingTools.format(this.buffer, message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            this.checkNotClosed();
            this.buffer.append("WARN: ");
            LoggingTools.format(this.buffer, message, args);
        }

        @Override
        public void close() {
            if (!this.buffer.isEmpty() && this.buffer.charAt(this.buffer.length() - 1) == '\n') {
                this.buffer.setLength(this.buffer.length() - 1);
            }
            this.logger.debug(this.buffer.toString());
            this.checkNotClosed();
            this.closed = true;
        }

        private void checkNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
        }
    }

    public static class OffLogWrapper
    implements LogWrapper {
        public String toString() {
            return "OFF";
        }

        @Override
        public boolean off() {
            return true;
        }

        @Override
        public void debug(String message, Object ... args) {
            throw new UnsupportedOperationException("off");
        }

        @Override
        public void warn(String message, Object ... args) {
            throw new UnsupportedOperationException("off");
        }

        @Generated
        public OffLogWrapper() {
        }
    }
}

