/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.logging.clientfilter;

import com.github.t1.logging.clientfilter.LogWrapper;
import com.github.t1.logging.clientfilter.LoggingOutputStream;
import com.github.t1.logging.clientfilter.LoggingTools;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;

@Priority(value=5900)
public class LoggingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final String LOGGING_OUTPUT_STREAM_PROPERTY = LoggingOutputStream.class.getName();

    public void filter(ClientRequestContext requestContext) {
        LogWrapper log = this.getLog(requestContext);
        try {
            if (log.off()) {
                return;
            }
            log.debug("sending {} request {}", requestContext.getMethod(), requestContext.getUri());
            requestContext.getStringHeaders().forEach((name, values) -> log.debug(">> {}: {}", name, LoggingTools.safe(name, values)));
            if (requestContext.hasEntity() && LoggingTools.isLoggable(requestContext.getMediaType())) {
                try {
                    OutputStream entityStream = requestContext.getEntityStream();
                    LoggingOutputStream stream = new LoggingOutputStream(entityStream, ">>", log, log::close);
                    requestContext.setProperty(LOGGING_OUTPUT_STREAM_PROPERTY, (Object)stream);
                    requestContext.setEntityStream((OutputStream)stream);
                }
                catch (RuntimeException e) {
                    log.debug("can't read entity stream... will log toString. Cause: {}", e.toString());
                    log.debug(">> {}", requestContext.getEntity());
                }
            } else {
                log.close();
            }
        }
        catch (RuntimeException e) {
            log.warn("error logging client request", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        block17: {
            LogWrapper log;
            block16: {
                block15: {
                    log = this.getLog(requestContext);
                    if (!log.off()) break block15;
                    try {
                        log.close();
                    }
                    catch (RuntimeException e2) {
                        log.warn("error closing log", e2);
                    }
                    return;
                }
                LoggingOutputStream loggingOutputStream = (LoggingOutputStream)requestContext.getProperty(LOGGING_OUTPUT_STREAM_PROPERTY);
                if (loggingOutputStream != null) {
                    loggingOutputStream.close();
                }
                log.debug("got response for {} {}", requestContext.getMethod(), requestContext.getUri());
                log.debug("<< Status: {} {}", responseContext.getStatus(), responseContext.getStatusInfo().getReasonPhrase());
                MultivaluedMap headers = responseContext.getHeaders();
                if (headers != null) {
                    headers.forEach((name, values) -> log.debug("<< {}: {}", name, LoggingTools.merge(values)));
                }
                if (!responseContext.hasEntity() || !LoggingTools.isLoggable(responseContext.getMediaType())) break block16;
                Charset charset = LoggingTools.charset(responseContext.getMediaType());
                String entity = new String(responseContext.getEntityStream().readAllBytes(), charset);
                entity.lines().forEach(line -> log.debug("<< {}", line));
                responseContext.setEntityStream((InputStream)new ByteArrayInputStream(entity.getBytes(charset)));
            }
            try {
                log.close();
            }
            catch (RuntimeException e2) {
                log.warn("error closing log", e2);
            }
            break block17;
            catch (RuntimeException e) {
                try {
                    log.warn("error logging client response", e);
                }
                catch (Throwable throwable) {
                    try {
                        log.close();
                    }
                    catch (RuntimeException e2) {
                        log.warn("error closing log", e2);
                    }
                    throw throwable;
                }
                try {
                    log.close();
                }
                catch (RuntimeException e2) {
                    log.warn("error closing log", e2);
                }
            }
        }
    }

    private LogWrapper getLog(ClientRequestContext requestContext) {
        Map properties = requestContext.getConfiguration().getProperties();
        Method method = (Method)properties.get("org.eclipse.microprofile.rest.client.invokedMethod");
        String loggerName = method == null ? LoggingClientFilter.class.getName() : method.getDeclaringClass().getName() + "." + method.getName();
        return LogWrapper.of(loggerName);
    }
}

