/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.logging.clientfilter;

import com.github.t1.logging.clientfilter.LogWrapper;
import com.github.t1.logging.clientfilter.LoggingOutputStream;
import com.github.t1.logging.clientfilter.LoggingTools;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;

@Provider
@Priority(value=5900)
public class LoggingContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        block15: {
            LogWrapper log;
            block14: {
                block13: {
                    log = this.getLog(requestContext);
                    if (!log.off()) break block13;
                    try {
                        log.close();
                    }
                    catch (RuntimeException e2) {
                        log.warn("error closing log", e2);
                    }
                    return;
                }
                log.debug("got {} request {}", requestContext.getMethod(), requestContext.getUriInfo().getRequestUri());
                requestContext.getHeaders().forEach((name, values) -> log.debug(">>> {}: {}", name, LoggingTools.safe(name, values)));
                if (!requestContext.hasEntity() || !LoggingTools.isLoggable(requestContext.getMediaType())) break block14;
                Charset charset = LoggingTools.charset(requestContext.getMediaType());
                String entity = new String(requestContext.getEntityStream().readAllBytes(), charset);
                entity.lines().forEach(line -> log.debug(">>> {}", line));
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(entity.getBytes(charset)));
            }
            try {
                log.close();
            }
            catch (RuntimeException e2) {
                log.warn("error closing log", e2);
            }
            break block15;
            catch (RuntimeException e) {
                try {
                    log.warn("error logging container request", e);
                }
                catch (Throwable throwable) {
                    try {
                        log.close();
                    }
                    catch (RuntimeException e2) {
                        log.warn("error closing log", e2);
                    }
                    throw throwable;
                }
                try {
                    log.close();
                }
                catch (RuntimeException e2) {
                    log.warn("error closing log", e2);
                }
            }
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        LogWrapper log = this.getLog(requestContext);
        try {
            if (log.off()) {
                return;
            }
            log.debug("sending response for {} {}", requestContext.getMethod(), requestContext.getUriInfo().getRequestUri());
            log.debug("<<< Status: {} {}", responseContext.getStatus(), responseContext.getStatusInfo().getReasonPhrase());
            responseContext.getStringHeaders().forEach((name, values) -> log.debug("<<< {}: {}", name, LoggingTools.merge(values)));
            if (responseContext.hasEntity() && LoggingTools.isLoggable(responseContext.getMediaType())) {
                responseContext.setEntityStream((OutputStream)new LoggingOutputStream(responseContext.getEntityStream(), "<<<", log, log::close));
            } else {
                log.close();
            }
        }
        catch (RuntimeException e) {
            log.warn("error logging container response", e);
        }
    }

    private LogWrapper getLog(ContainerRequestContext requestContext) {
        Method method;
        Object loggerName = LoggingContainerFilter.class.getName();
        Object resourceMethodInvoker = requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        if (resourceMethodInvoker != null && (method = this.getMethod(resourceMethodInvoker)) != null) {
            loggerName = method.getDeclaringClass().getName() + "." + method.getName();
        }
        return LogWrapper.of((String)loggerName);
    }

    private Method getMethod(Object resourceMethodInvoker) {
        try {
            Method method = resourceMethodInvoker.getClass().getMethod("getMethod", new Class[0]);
            return (Method)method.invoke(resourceMethodInvoker, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }
}

