/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.logging.clientfilter;

import com.github.t1.logging.clientfilter.LogWrapper;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class LoggingOutputStream
extends FilterOutputStream {
    private final String direction;
    private final StringBuilder buffer = new StringBuilder();
    private final LogWrapper log;
    private final Runnable closeAction;

    public LoggingOutputStream(OutputStream stream, String direction, LogWrapper log, Runnable closeAction) {
        super(stream);
        this.direction = direction;
        this.log = log;
        this.closeAction = closeAction;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.buffer.appendCodePoint(b);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buffer.toString().lines().forEach(line -> this.log.debug("{} {}", this.direction, line));
        this.closeAction.run();
    }
}

