/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.logging.clientfilter;

import jakarta.ws.rs.core.MediaType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public class LoggingTools {
    public static final String SINGLE = "..single";
    private static final int SAFE_PASSWORD_LEN = 12;

    static String safe(String name, List<String> values) {
        if ("Authorization".equalsIgnoreCase(name)) {
            ArrayList<String> safeValues = new ArrayList<String>(values.size());
            for (String value : values) {
                String[] decoded;
                Object safeValue = "<hidden>";
                String[] split = value.split(" ", 2);
                if (split.length > 1 && "Basic".equalsIgnoreCase(split[0]) && (decoded = new String(Base64.getDecoder().decode(split[1])).split(":", 2)).length > 1 && decoded[1].length() >= 12) {
                    String username = decoded[0];
                    safeValue = username + ":" + (String)safeValue;
                }
                safeValues.add((String)safeValue);
            }
            values = safeValues;
        }
        return LoggingTools.merge(values);
    }

    static String merge(List<String> values) {
        return String.join((CharSequence)", ", values);
    }

    static boolean isLoggable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return LoggingTools.isApplication(mediaType, "json") || LoggingTools.isApplication(mediaType, "xml") || mediaType.isCompatible(MediaType.TEXT_PLAIN_TYPE);
    }

    private static boolean isApplication(MediaType mediaType, String subType) {
        return mediaType.getType().equals("application") && (mediaType.getSubtype().equals(subType) || mediaType.getSubtype().endsWith("+" + subType));
    }

    static Charset charset(MediaType mediaType) {
        return Optional.ofNullable(mediaType).map(MediaType::getParameters).flatMap(params -> Optional.ofNullable((String)params.get("charset"))).map(Charset::forName).orElse(StandardCharsets.ISO_8859_1);
    }

    static void format(StringBuilder buffer, String message, Object[] args) {
        int argIndex = 0;
        block4: for (char c : message.toCharArray()) {
            switch (c) {
                case '{': {
                    continue block4;
                }
                case '}': {
                    buffer.append(args[argIndex++]);
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append('\n');
    }
}

