/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.locator.webjars;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StaticFilesLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaticFilesLoader.class);
    protected final String name;
    private final String prefix;

    Response response(String filePath) {
        String path = this.prefix + filePath;
        log.trace("look for static file: {}: {}: {}", new Object[]{this.name, this.prefix, filePath});
        InputStream stream = StaticFilesLoader.classLoader().getResourceAsStream(path);
        if (stream == null) {
            return null;
        }
        log.trace("found {} in {}", (Object)filePath, (Object)this.name);
        return Response.ok((Object)stream).type(StaticFilesLoader.type(StaticFilesLoader.fileSuffix(filePath))).build();
    }

    private static String fileSuffix(String filePath) {
        if (filePath == null) {
            return null;
        }
        int i = filePath.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return filePath.substring(i);
    }

    private static MediaType type(String fileSuffix) {
        if (fileSuffix == null) {
            return null;
        }
        return switch (fileSuffix) {
            case ".css" -> MediaType.valueOf((String)"text/css");
            case ".html" -> MediaType.TEXT_HTML_TYPE;
            case ".gif" -> MediaType.valueOf((String)"image/gif");
            case ".ico" -> MediaType.valueOf((String)"image/x-icon");
            case ".jpeg" -> MediaType.valueOf((String)"image/jpeg");
            case ".png" -> MediaType.valueOf((String)"image/png");
            case ".raml" -> MediaType.valueOf((String)"application/raml+yaml");
            case ".otf" -> MediaType.valueOf((String)"font/opentype");
            case ".ttf" -> MediaType.valueOf((String)"font/truetype");
            case ".woff" -> MediaType.valueOf((String)"font/x-font-woff");
            case ".woff2" -> MediaType.valueOf((String)"font/x-font-woff2");
            default -> MediaType.TEXT_PLAIN_TYPE;
        };
    }

    static ClassLoader classLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = StaticFilesLoader.classLoader();
        }
        return loader;
    }

    @Generated
    public StaticFilesLoader(String name, String prefix) {
        this.name = name;
        this.prefix = prefix;
    }
}

