/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.locator.webjars;

import com.github.t1.locator.webjars.StaticFilesLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/webjars")
@ApplicationScoped
public class WebJarsResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebJarsResource.class);
    private final Map<String, StaticFilesLoader> loaders = new ConcurrentHashMap<String, StaticFilesLoader>();

    @GET
    @Path(value="/{artifact}/{filePath:.*}")
    public Response getStaticResource(@PathParam(value="artifact") String artifact, @PathParam(value="filePath") String filePath) {
        StaticFilesLoader loader = this.getLoaderFor(artifact);
        if (loader == null) {
            return this.notFound("artifact not found '" + artifact + "' (for path '" + filePath + "')");
        }
        Response response = loader.response(filePath);
        if (response == null) {
            return this.notFound("resource '" + filePath + "' not found in '" + artifact + "'");
        }
        return response;
    }

    private Response notFound(String message) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(message + "\n")).type("text/plain").build();
    }

    private StaticFilesLoader getLoaderFor(String artifact) {
        return this.loaders.computeIfAbsent(artifact, this::createLoaderFor);
    }

    private StaticFilesLoader createLoaderFor(String artifact) {
        String version = this.versionOf(artifact);
        if (version == null) {
            return new NotFoundLoader(artifact);
        }
        return new WebjarFilesLoader(artifact, version);
    }

    private String versionOf(String artifact) {
        String string;
        block10: {
            URL resource = this.pomPropertiesResourceFor(artifact);
            if (resource == null) {
                log.warn("no pom properties found for {}", (Object)artifact);
                return null;
            }
            InputStream is = resource.openStream();
            try {
                Properties properties = new Properties();
                properties.load(is);
                assert (properties.getProperty("artifactId").equals(artifact));
                String version = properties.getProperty("version");
                log.debug("found version {} for {}", (Object)version, (Object)artifact);
                string = version;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("exception while loading {}: {}", (Object)artifact, (Object)e.toString());
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private URL pomPropertiesResourceFor(String artifact) {
        String path = "/META-INF/maven/org.webjars/" + artifact + "/pom.properties";
        URL resource = StaticFilesLoader.classLoader().getResource(path);
        if (resource == null) {
            path = "/META-INF/maven/org.webjars.npm/" + artifact + "/pom.properties";
            resource = StaticFilesLoader.classLoader().getResource(path);
        }
        if (resource == null) {
            path = "/META-INF/maven/org.webjars.bower/" + artifact + "/pom.properties";
            resource = StaticFilesLoader.classLoader().getResource(path);
        }
        return resource;
    }

    private class NotFoundLoader
    extends StaticFilesLoader {
        NotFoundLoader(String name) {
            super(name, "");
        }

        @Override
        public Response response(String filePath) {
            return WebJarsResource.this.notFound("no webjar found for " + this.name + ".");
        }
    }

    private static class WebjarFilesLoader
    extends StaticFilesLoader {
        WebjarFilesLoader(String artifact, String version) {
            super(artifact + " webjar", "META-INF/resources/webjars/" + artifact + "/" + version + "/");
        }
    }
}

