/*
 * Decompiled with CFR 0.152.
 */
package com.github.takumin.simplesgfparser.parser;

import com.github.takumin.simplesgfparser.entity.Collection;
import com.github.takumin.simplesgfparser.entity.GameTree;
import com.github.takumin.simplesgfparser.entity.Node;
import com.github.takumin.simplesgfparser.entity.Sequence;
import com.github.takumin.simplesgfparser.exception.SGFParseError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SGFParser {
    private String sgf;
    private Collection collection;

    public SGFParser(String sgf) {
        this.sgf = sgf;
        this.collection = new Collection();
        this.parse();
    }

    public GameTree getSingleGameTree() {
        return this.getGameTree(0);
    }

    public GameTree getGameTree(int index) {
        return this.collection.getTrees().get(index);
    }

    public int getGameTreeCount() {
        return this.collection.getTrees().size();
    }

    private void parse() {
        List<String> rawTrees = this.getRawTrees(this.sgf);
        for (String rawTree : rawTrees) {
            GameTree gt = this.parseTree(rawTree);
            this.collection.addGameTree(gt);
        }
    }

    private List<String> getRawTrees(String sgf) {
        ArrayList<String> result = new ArrayList<String>();
        int rbCount = 0;
        int lbCount = 0;
        int start = 0;
        int end = 0;
        for (int i = 0; i < sgf.length(); ++i) {
            char c = sgf.charAt(i);
            if (c == '(') {
                if (rbCount == 0) {
                    start = i;
                }
                ++rbCount;
                continue;
            }
            if (c != ')' || rbCount != ++lbCount) continue;
            end = i;
            result.add(sgf.substring(start, end + 1));
            rbCount = 0;
            lbCount = 0;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GameTree parseTree(String rawTree) {
        GameTree result = new GameTree();
        String regex = "^\\((;[^\\(]+)(\\(.+\\))?\\)$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(rawTree);
        if (!m.find()) throw new SGFParseError("Illegal format");
        if (m.groupCount() == 3) {
            result.setSequence(this.parseSequence(m.group(1)));
            result.addGameTree(this.parseTree(m.group(2)));
            return result;
        } else {
            if (m.groupCount() != 2) throw new SGFParseError("Illegal format");
            String rawSequence = m.group(1);
            result.setSequence(this.parseSequence(rawSequence));
        }
        return result;
    }

    private Sequence parseSequence(String rawSequence) {
        String[] rawNodes;
        Sequence result = new Sequence();
        char firstChar = rawSequence.charAt(0);
        if (firstChar != ';') {
            throw new SGFParseError("Illegal format");
        }
        rawSequence = rawSequence.substring(1);
        for (String rawNode : rawNodes = rawSequence.split(";")) {
            result.addNode(this.parseNode(rawNode));
        }
        return result;
    }

    private Node parseNode(String rawNode) {
        Node result = new Node();
        String regex1 = "[A-Z]+?\\[.+?\\]";
        Pattern p1 = Pattern.compile(regex1);
        Matcher m1 = p1.matcher(rawNode);
        while (m1.find()) {
            String k;
            String regex2 = "([A-Z]+?)\\[(.+?)\\]";
            Pattern p2 = Pattern.compile(regex2);
            Matcher m2 = p2.matcher(k = m1.group());
            if (m2.find()) {
                if (m2.groupCount() < 2) {
                    throw new SGFParseError("Illegal format Node found");
                }
                result.addProperty(m2.group(1), m2.group(2));
                continue;
            }
            throw new SGFParseError("Illegal format Node found");
        }
        return result;
    }
}

