/*
 * Decompiled with CFR 0.152.
 */
package com.github.talberto.easybeans.gen;

import com.github.talberto.easybeans.gen.ClassDefinition;
import com.github.talberto.easybeans.gen.MetaBean;
import com.github.talberto.easybeans.gen.MetaClass;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STGroupFile;

public class CodeGenerator {
    private static final String TEMPLATES_BASEDIR = "/com/github/talberto/easybeans/gen/template";
    STGroup mGroup;
    Logger mLogger = LoggerFactory.getLogger((String)"");

    public CodeGenerator() {
        try {
            URL url = this.getClass().getResource(TEMPLATES_BASEDIR);
            File dir = new File(url.toURI());
            this.mGroup = new STGroupDir(dir.getAbsolutePath());
        }
        catch (URISyntaxException e) {
            this.mLogger.error("Error finding the templates", (Throwable)e);
        }
    }

    public String generate(ClassDefinition pClassDefinition) throws URISyntaxException {
        ST st = this.mGroup.getInstanceOf("class_def");
        st.add("class", (Object)pClassDefinition);
        return st.render();
    }

    public String generate(MetaClass pBean) {
        ST st = this.getBeanTemplate();
        st.add("bean", (Object)pBean);
        return st.render();
    }

    private ST getBeanTemplate() {
        try {
            URL url = this.getClass().getResource("/com/github/talberto/easybeans/gen/template/class.stg");
            File file = new File(url.toURI());
            STGroupFile group = new STGroupFile(file.getAbsolutePath());
            return group.getInstanceOf("class_decl");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The url for the group file is wrong", e);
        }
    }

    public String generate(MetaBean pBean) {
        MetaClass metaClass = pBean.getMetaClass();
        ST template = this.getBeanTemplate();
        template.add("class", (Object)metaClass);
        return template.render();
    }
}

