/*
 * Decompiled with CFR 0.152.
 */
package com.github.talberto.easybeans.gen;

import com.github.talberto.easybeans.gen.MetaClass;
import com.github.talberto.easybeans.gen.MetaGetter;
import com.github.talberto.easybeans.gen.MetaImport;
import com.github.talberto.easybeans.gen.MetaInstanceVar;
import com.github.talberto.easybeans.gen.MetaProperty;
import com.github.talberto.easybeans.gen.MetaSetter;
import com.google.common.base.CaseFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class MetaBean {
    String mName;
    List<MetaProperty> mProperties;
    MetaClass mMetaClass;

    public MetaBean(String pName, List<MetaProperty> pProperties) {
        this.mName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, pName);
        this.mProperties = pProperties;
        LinkedList<MetaInstanceVar> instanceVars = new LinkedList<MetaInstanceVar>();
        LinkedList<MetaGetter> getters = new LinkedList<MetaGetter>();
        LinkedList<MetaSetter> setters = new LinkedList<MetaSetter>();
        HashSet<MetaImport> imports = new HashSet<MetaImport>();
        for (MetaProperty property : this.mProperties) {
            instanceVars.add(property.getInstanceVar());
            getters.add(property.getGetter());
            setters.add(property.getSetter());
            imports.addAll(property.getImports());
        }
        this.mMetaClass = new MetaClass(this.mName, instanceVars, getters, setters, imports);
    }

    public String getName() {
        return this.mName;
    }

    public List<MetaProperty> getProperties() {
        return this.mProperties;
    }

    public MetaClass getMetaClass() {
        return this.mMetaClass;
    }

    public String toString() {
        return "MetaBean [mName=" + this.mName + ", mProperties=" + this.mProperties + ", mMetaClass=" + this.mMetaClass + "]";
    }
}

