/*
 * Decompiled with CFR 0.152.
 */
package com.github.talberto.easybeans.gen;

import com.github.talberto.easybeans.gen.MetaGetter;
import com.github.talberto.easybeans.gen.MetaImport;
import com.github.talberto.easybeans.gen.MetaInstanceVar;
import com.github.talberto.easybeans.gen.MetaSetter;
import com.github.talberto.easybeans.gen.MetaType;
import com.github.talberto.easybeans.gen.Visibility;
import java.util.HashSet;
import java.util.Set;

public class MetaProperty {
    String mName;
    MetaType mType;
    MetaInstanceVar mInstanceVar;
    MetaGetter mGetter;
    MetaSetter mSetter;
    Set<MetaImport> mImports = new HashSet<MetaImport>();

    public MetaProperty(String pName, MetaType pType) {
        this.mName = pName;
        this.mType = pType;
        this.mInstanceVar = new MetaInstanceVar(this.mName, Visibility.PROTECTED, pType);
        this.mGetter = new MetaGetter(this, this.mInstanceVar);
        this.mSetter = new MetaSetter(this, this.mInstanceVar);
        this.mImports = pType.getImports();
    }

    public MetaInstanceVar getInstanceVar() {
        return this.mInstanceVar;
    }

    public MetaGetter getGetter() {
        return this.mGetter;
    }

    public MetaSetter getSetter() {
        return this.mSetter;
    }

    public Set<MetaImport> getImports() {
        return this.mImports;
    }

    public String getName() {
        return this.mName;
    }

    public MetaType getType() {
        return this.mInstanceVar.getType();
    }

    public String toString() {
        return "MetaProperty [mName=" + this.mName + ", mType=" + this.mType + "]";
    }
}

