/*
 * Decompiled with CFR 0.152.
 */
package com.github.talberto.easybeans.gen;

import com.github.talberto.easybeans.gen.MetaImport;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetaType {
    private static final Function<Type, String> sTypeToTypename = new Function<Type, String>(){

        public String apply(Type pType) {
            return MetaType.getName(pType);
        }
    };
    private static final Function<Type, Set<MetaImport>> sTypeToMetaimport = new Function<Type, Set<MetaImport>>(){

        public Set<MetaImport> apply(Type pType) {
            return MetaType.getImports(pType);
        }
    };
    protected String mName;
    protected Set<MetaImport> mImports;

    public MetaType(String pName, Set<MetaImport> pImports) {
        this.mName = pName;
        this.mImports = pImports;
    }

    public String getName() {
        return this.mName;
    }

    public static MetaType of(TypeToken<?> pTypeToken) {
        Type type = pTypeToken.getType();
        String name = MetaType.getName(type);
        Set<MetaImport> imports = MetaType.getImports(type);
        return new MetaType(name, imports);
    }

    private static Set<MetaImport> getImports(Type pType) {
        HashSet imports = Sets.newHashSet();
        if (pType instanceof Class) {
            Class klazz = (Class)pType;
            imports.addAll(MetaType.getImportsFromClass(klazz));
        } else if (pType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)pType;
            imports.addAll(MetaType.getImportsFromParameterizedType(paramType));
        } else if (pType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)pType;
            imports.addAll(MetaType.getImportsFromTypeVariable(typeVariable));
        }
        return imports;
    }

    private static Set<MetaImport> getImportsFromTypeVariable(TypeVariable<?> pTypeVariable) {
        throw new UnsupportedOperationException();
    }

    private static Set<MetaImport> getImportsFromParameterizedType(ParameterizedType pParamType) {
        Type rawType = pParamType.getRawType();
        Set<MetaImport> rawTypeImports = MetaType.getImports(rawType);
        List<Type> actualParamTypes = Arrays.asList(pParamType.getActualTypeArguments());
        List actualParamSetImports = Lists.transform(actualParamTypes, sTypeToMetaimport);
        Set<MetaImport> resultingImports = rawTypeImports;
        for (Set imports : actualParamSetImports) {
            resultingImports.addAll(imports);
        }
        return resultingImports;
    }

    private static Set<MetaImport> getImportsFromClass(Class<?> pClass) {
        return Sets.newHashSet((Object[])new MetaImport[]{new MetaImport(pClass.getName())});
    }

    protected static String getName(Type pType) {
        String name = "";
        if (pType instanceof Class) {
            Class klazz = (Class)pType;
            name = MetaType.getNameFromClass(klazz);
        } else if (pType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)pType;
            name = MetaType.getNameFromParameterizedType(paramType);
        } else if (pType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)pType;
            name = MetaType.getNameFromTypeVariable(typeVariable);
        }
        return name;
    }

    private static String getNameFromTypeVariable(TypeVariable<?> pTypeVariable) {
        throw new UnsupportedOperationException();
    }

    private static String getNameFromClass(Class<?> klazz) {
        String name = klazz.getSimpleName();
        return name;
    }

    private static String getNameFromParameterizedType(ParameterizedType pParamType) {
        Type rawType = pParamType.getRawType();
        String rawTypeName = MetaType.getName(rawType);
        List<Type> actualParamTypes = Arrays.asList(pParamType.getActualTypeArguments());
        List actualParamNames = Lists.transform(actualParamTypes, sTypeToTypename);
        return String.format("%s<%s>", rawTypeName, Joiner.on((String)",").join((Iterable)actualParamNames));
    }

    public Set<MetaImport> getImports() {
        return this.mImports;
    }

    public String toString() {
        return "MetaType [mName=" + this.mName + ", mImports=" + this.mImports + "]";
    }
}

