/*******************************************************************************
 * Copyright 2014, 2021 gwt-ol
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package ol.style;

import jsinterop.annotations.JsFunction;
import ol.geom.SimpleGeometryCoordinates;
import ol.render.State;

/**
 * Custom renderer function.
 *
 * @author TDesjardins
 *
 */
@FunctionalInterface
@JsFunction
public interface RenderFunction {

    /**
     * @param pixelCoordinates The pixel coordinates of the geometry in GeoJSON notation.
     * @param renderState render state of the layer renderer.
     */
    void render(SimpleGeometryCoordinates pixelCoordinates, State renderState);

}