/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

@Mojo(name="generateRunners", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GenerateRunnersMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="cucumber.glue", required=true)
    private String glue;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/cucumber", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="src/test/resources/features/", property="featuresDir", required=true)
    private File featuresDirectory;
    @Parameter(defaultValue="true", property="cucumber.strict", required=true)
    private boolean strict;
    @Parameter(defaultValue="json", property="cucumber.format", required=true)
    private String format;
    @Parameter(defaultValue="false", property="cucumber.monochrome", required=true)
    private boolean monochrome;
    @Parameter(defaultValue="\"@complete\", \"@accepted\"", property="cucumber.tags", required=true)
    private String tags;
    private String featureFileLocation;
    private int fileCounter = 1;
    private Template velocityTemplate;

    public void execute() throws MojoExecutionException {
        if (!this.featuresDirectory.exists()) {
            throw new MojoExecutionException("Features directory does not exist");
        }
        File f = this.outputDirectory;
        this.quoteGlueStrings();
        this.initTemplate();
        Collection featureFiles = FileUtils.listFiles((File)this.featuresDirectory, (String[])new String[]{"feature"}, (boolean)true);
        if (!f.exists()) {
            f.mkdirs();
        }
        for (File file : featureFiles) {
            String outputFileName = String.format("Parallel%02dIT.java", this.fileCounter);
            this.setFeatureFileLocation(file);
            File outputFile = new File(f, outputFileName);
            FileWriter w = null;
            try {
                w = new FileWriter(outputFile);
                this.writeContentFromTemplate(w);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + outputFile, (Exception)e);
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException e) {}
                }
            }
            ++this.fileCounter;
        }
        this.getLog().info((CharSequence)("Adding " + this.outputDirectory.getAbsolutePath() + " to test-compile source root"));
        this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private void quoteGlueStrings() {
        String[] packageStrs = this.glue.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packageStrs.length; ++i) {
            String packageStr = packageStrs[i];
            sb.append(String.format("\"%s\"", packageStr.trim()));
            if (i >= packageStrs.length - 1) continue;
            sb.append(", ");
        }
        this.glue = sb.toString();
    }

    private void setFeatureFileLocation(File file) {
        this.featureFileLocation = file.getPath().replace(this.featuresDirectory.getPath(), this.featuresDirectory.getName());
    }

    private void writeContentFromTemplate(Writer writer) {
        VelocityContext context = new VelocityContext();
        context.put("strict", (Object)this.strict);
        context.put("featureFile", (Object)this.featureFileLocation);
        String outputFile = String.format("%s.%s", this.fileCounter, this.format);
        context.put("outputFile", (Object)outputFile);
        context.put("reportType", (Object)this.format);
        context.put("fileCounter", (Object)String.format("%02d", this.fileCounter));
        context.put("tags", (Object)this.tags);
        context.put("monochrome", (Object)this.monochrome);
        context.put("glue", (Object)this.glue);
        this.velocityTemplate.merge((Context)context, writer);
    }

    private void initTemplate() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine engine = new VelocityEngine(props);
        engine.init();
        this.velocityTemplate = engine.getTemplate("cucumber-junit-runner.vm");
    }
}

