/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.ClassNameGenerator;
import com.github.timm.cucumber.generate.FileGeneratorConfig;
import com.github.timm.cucumber.generate.OverriddenCucumberOptionsParameters;
import com.github.timm.cucumber.options.TagParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CucumberITGenerator {
    private final FileGeneratorConfig config;
    private final OverriddenCucumberOptionsParameters overriddenParameters;
    int fileCounter = 1;
    private String featureFileLocation;
    private Template velocityTemplate;
    private ClassNameGenerator classNameGenerator = new ClassNameGenerator();

    public CucumberITGenerator(FileGeneratorConfig config, OverriddenCucumberOptionsParameters overriddenParameters) {
        this.config = config;
        this.overriddenParameters = overriddenParameters;
        this.initTemplate();
    }

    private void initTemplate() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine engine = new VelocityEngine(props);
        engine.init();
        this.velocityTemplate = this.config.useTestNG() ? engine.getTemplate("cucumber-testng-runner.vm", this.config.getEncoding()) : engine.getTemplate("cucumber-junit-runner.vm", this.config.getEncoding());
    }

    void generateCucumberITFiles(File outputDirectory, Collection<File> featureFiles) throws MojoExecutionException {
        for (File file : featureFiles) {
            String outputFileName;
            if (this.shouldSkipFile(file)) continue;
            if (this.config.getNamingScheme().equals("simple")) {
                outputFileName = this.classNameGenerator.generateSimpleClassName(this.fileCounter);
            } else if (this.config.getNamingScheme().equals("feature-title")) {
                outputFileName = this.classNameGenerator.generateClassNameFromFeatureFileName(file.getName(), this.fileCounter);
            } else {
                throw new MojoExecutionException("Error in configuration ; accepted value for tag 'namingScheme' are 'simple' or 'feature-title'");
            }
            this.setFeatureFileLocation(file);
            File outputFile = new File(outputDirectory, outputFileName);
            FileWriter w = null;
            try {
                w = new FileWriter(outputFile);
                this.writeContentFromTemplate(w);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + outputFile, (Exception)e);
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++this.fileCounter;
        }
    }

    private boolean shouldSkipFile(File file) {
        if (this.config.filterFeaturesByTags()) {
            try {
                String fileContents = FileUtils.readFileToString((File)file);
                if (!this.fileContainsMatchingTags(fileContents)) {
                    return true;
                }
            }
            catch (IOException e) {
                this.config.getLog().info((CharSequence)("Failed to read contents of " + file.getPath() + ". Parallel Test shall be created."));
            }
        }
        return false;
    }

    private boolean fileContainsMatchingTags(String fileContents) {
        List<List<String>> tagGroupsAnded = TagParser.splitQuotedTagsIntoParts(this.overriddenParameters.getTags());
        for (List<String> tagGroup : tagGroupsAnded) {
            if (this.fileContainsAnyTags(fileContents, tagGroup)) continue;
            return false;
        }
        return true;
    }

    private boolean fileContainsAnyTags(String fileContents, List<String> tags) {
        for (String tag : tags) {
            if (tag.startsWith("~")) {
                return true;
            }
            if (!fileContents.contains(tag)) continue;
            return true;
        }
        return false;
    }

    private void setFeatureFileLocation(File file) {
        File featuresDirectory = this.config.getFeaturesDirectory();
        this.featureFileLocation = file.getPath().replace(featuresDirectory.getPath(), featuresDirectory.getName()).replace(File.separatorChar, '/');
    }

    private void writeContentFromTemplate(Writer writer) {
        VelocityContext context = new VelocityContext();
        context.put("strict", (Object)this.overriddenParameters.isStrict());
        context.put("featureFile", (Object)this.featureFileLocation);
        context.put("reports", (Object)this.createFormatStrings());
        context.put("fileCounter", (Object)String.format("%02d", this.fileCounter));
        context.put("tags", (Object)this.overriddenParameters.getTags());
        context.put("monochrome", (Object)this.overriddenParameters.isMonochrome());
        context.put("cucumberOutputDir", (Object)this.config.getCucumberOutputDir());
        context.put("glue", (Object)this.quoteGlueStrings());
        this.velocityTemplate.merge((Context)context, writer);
    }

    private String createFormatStrings() {
        String[] formatStrs = this.overriddenParameters.getFormat().split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < formatStrs.length; ++i) {
            String formatStr = formatStrs[i].trim();
            sb.append(String.format("\"%s:%s/%s.%s\"", formatStr, this.config.getCucumberOutputDir().replace('\\', '/'), this.fileCounter, formatStr));
            if (i >= formatStrs.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String quoteGlueStrings() {
        String[] packageStrs = this.overriddenParameters.getGlue().split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packageStrs.length; ++i) {
            String packageStr = packageStrs[i];
            sb.append(String.format("\"%s\"", packageStr.trim()));
            if (i >= packageStrs.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

