/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.google.common.base.CaseFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class ClassNameGenerator {
    Pattern startsWithDigit = Pattern.compile("^\\d.*");

    public String generateClassNameFromFeatureFileName(String featureFileName, int fileCounter) {
        String fileNameWithNoExtension = FilenameUtils.removeExtension((String)featureFileName);
        fileNameWithNoExtension = fileNameWithNoExtension.replaceAll("_", "-");
        String className = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, fileNameWithNoExtension = fileNameWithNoExtension.replaceAll(" ", ""));
        Matcher startsWithDigitCheck = this.startsWithDigit.matcher(className);
        if (startsWithDigitCheck.matches()) {
            className = "_" + className;
        }
        return String.format(className + "%02dIT.java", fileCounter);
    }

    public String generateSimpleClassName(int fileCounter) {
        return String.format("Parallel%02dIT.java", fileCounter);
    }
}

