/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagParser {
    private static final String QUOTE = Pattern.quote("\"");
    private static final String NOT_QUOTE_CHARS = "[^" + QUOTE + "]*?";
    private static final String COMMA = ",";

    public static String parseTags(List<String> tags) {
        if (tags.isEmpty()) {
            return "";
        }
        return '\"' + StringUtils.join(tags, (String)"\",\"") + '\"';
    }

    public static List<List<String>> splitQuotedTagsIntoParts(String quotedTags) {
        String TAG_GROUP = "(" + QUOTE + NOT_QUOTE_CHARS + QUOTE + ")";
        Matcher matcher = Pattern.compile(TAG_GROUP).matcher(quotedTags);
        ArrayList<List<String>> allTags = new ArrayList<List<String>>();
        while (matcher.find()) {
            String tags = matcher.group(1);
            allTags.add(Arrays.asList(tags.replaceAll("\\\"", "").split(COMMA)));
        }
        return allTags;
    }
}

