/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.CucumberITGenerator;
import com.github.timm.cucumber.generate.CucumberITGeneratorFactory;
import com.github.timm.cucumber.generate.FileGeneratorConfig;
import com.github.timm.cucumber.generate.OverriddenCucumberOptionsParameters;
import com.github.timm.cucumber.generate.ParallelScheme;
import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import com.github.timm.cucumber.generate.name.ClassNamingSchemeFactory;
import com.github.timm.cucumber.generate.name.OneUpCounter;
import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generateRunners", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GenerateRunnersMojo
extends AbstractMojo
implements FileGeneratorConfig {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="cucumber.glue", required=true)
    private String glue;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/cucumber", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="target/cucumber-parallel", property="cucumberOutputDir", required=true)
    private String cucumberOutputDir;
    @Parameter(defaultValue="src/test/resources/features/", property="featuresDir", required=true)
    private File featuresDirectory;
    @Parameter(defaultValue="true", property="cucumber.strict", required=true)
    private boolean strict;
    @Parameter(defaultValue="json", property="cucumber.format", required=true)
    private String format;
    @Parameter(defaultValue="false", property="cucumber.monochrome", required=true)
    private boolean monochrome;
    @Parameter(property="cucumber.tags", required=false)
    private String tags;
    @Parameter(defaultValue="UTF-8", property="project.build.sourceEncoding", readonly=true)
    private String encoding;
    @Parameter(defaultValue="false", property="cucumber.tags.filterOutput", required=true)
    private boolean filterFeaturesByTags;
    @Parameter(defaultValue="false", property="useTestNG", required=true)
    private boolean useTestNG;
    @Parameter(property="cucumber.options", required=false)
    private String cucumberOptions;
    @Parameter(defaultValue="simple", property="namingScheme", required=false)
    private String namingScheme;
    @Parameter(property="namingPattern", required=false)
    private String namingPattern;
    @Parameter(property="packageName", required=false)
    private String packageName;
    @Parameter(defaultValue="FEATURE", property="parallelScheme", required=true)
    private ParallelScheme parallelScheme;
    @Parameter(property="customVmTemplate", required=false)
    private String customVmTemplate;
    private CucumberITGenerator fileGenerator;

    public void execute() throws MojoExecutionException {
        File packageDirectory;
        if (!this.featuresDirectory.exists()) {
            throw new MojoExecutionException("Features directory does not exist");
        }
        Collection featureFiles = FileUtils.listFiles((File)this.featuresDirectory, (String[])new String[]{"feature"}, (boolean)true);
        this.createOutputDirIfRequired();
        this.fileGenerator = this.createFileGenerator();
        File file = packageDirectory = this.packageName == null ? this.outputDirectory : new File(this.outputDirectory, this.packageName.replace('.', '/'));
        if (!packageDirectory.exists()) {
            packageDirectory.mkdirs();
        }
        this.fileGenerator.generateCucumberITFiles(packageDirectory, featureFiles);
        this.getLog().info((CharSequence)("Adding " + this.outputDirectory.getAbsolutePath() + " to test-compile source root"));
        this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private CucumberITGenerator createFileGenerator() throws MojoExecutionException {
        OverriddenCucumberOptionsParameters overriddenParameters = this.overrideParametersWithCucumberOptions();
        ClassNamingSchemeFactory factory = new ClassNamingSchemeFactory(new OneUpCounter());
        ClassNamingScheme classNamingScheme = factory.create(this.namingScheme, this.namingPattern);
        return new CucumberITGeneratorFactory(this, overriddenParameters, classNamingScheme).create(this.parallelScheme);
    }

    private void createOutputDirIfRequired() {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    private OverriddenCucumberOptionsParameters overrideParametersWithCucumberOptions() {
        OverriddenCucumberOptionsParameters overriddenParameters = new OverriddenCucumberOptionsParameters();
        overriddenParameters.setTags(this.tags).setGlue(this.glue).setStrict(this.strict).setFormat(this.format).setMonochrome(this.monochrome);
        overriddenParameters.overrideParametersWithCucumberOptions(this.cucumberOptions);
        return overriddenParameters;
    }

    public boolean filterFeaturesByTags() {
        return this.filterFeaturesByTags;
    }

    public File getFeaturesDirectory() {
        return this.featuresDirectory;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCucumberOutputDir() {
        return this.cucumberOutputDir;
    }

    public boolean useTestNG() {
        return this.useTestNG;
    }

    public String getNamingScheme() {
        return this.namingScheme;
    }

    public String getNamingPattern() {
        return this.namingPattern;
    }

    public String getCustomVmTemplate() {
        return this.customVmTemplate;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public File getProjectBasedir() {
        return this.project.getBasedir();
    }
}

