/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.options.RuntimeOptions;
import com.github.timm.cucumber.options.TagParser;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class OverriddenCucumberOptionsParameters {
    private String tags;
    private String glue;
    private boolean strict;
    private String format;
    private boolean monochrome;

    OverriddenCucumberOptionsParameters() {
    }

    public OverriddenCucumberOptionsParameters setTags(String tags) {
        this.tags = tags;
        return this;
    }

    public OverriddenCucumberOptionsParameters setGlue(String glue) {
        this.glue = glue;
        return this;
    }

    public OverriddenCucumberOptionsParameters setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public OverriddenCucumberOptionsParameters setFormat(String format) {
        this.format = format;
        return this;
    }

    public OverriddenCucumberOptionsParameters setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
        return this;
    }

    public void overrideParametersWithCucumberOptions(String cucumberOptions) {
        List<String> glue;
        if (cucumberOptions == null || cucumberOptions.isEmpty()) {
            return;
        }
        RuntimeOptions options = new RuntimeOptions(cucumberOptions);
        List<String> tags = options.getFilters();
        String parsedTags = TagParser.parseTags(tags);
        if (!parsedTags.isEmpty()) {
            this.tags = parsedTags;
        }
        if (!(glue = options.getGlue()).isEmpty()) {
            this.glue = StringUtils.join(glue, (String)",");
        }
        if (options.isStrict()) {
            this.strict = true;
        }
        if (!options.getPluginNames().isEmpty()) {
            this.format = StringUtils.join(options.getPluginNames(), (String)",");
        }
        if (options.isMonochrome()) {
            this.monochrome = true;
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String getFormat() {
        return this.format;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public String getGlue() {
        return this.glue;
    }
}

