/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.CucumberITGenerator;
import com.github.timm.cucumber.generate.FileGeneratorConfig;
import com.github.timm.cucumber.generate.OverriddenCucumberOptionsParameters;
import com.github.timm.cucumber.generate.Plugin;
import com.github.timm.cucumber.generate.filter.TagFilter;
import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.TokenMatcher;
import gherkin.ast.Feature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CucumberITGeneratorByFeature
implements CucumberITGenerator {
    private final FileGeneratorConfig config;
    private final OverriddenCucumberOptionsParameters overriddenParameters;
    private int fileCounter = 1;
    private String featureFileLocation;
    private Template velocityTemplate;
    private String outputFileName;
    private final ClassNamingScheme classNamingScheme;

    public CucumberITGeneratorByFeature(FileGeneratorConfig config, OverriddenCucumberOptionsParameters overriddenParameters, ClassNamingScheme classNamingScheme) {
        this.config = config;
        this.overriddenParameters = overriddenParameters;
        this.classNamingScheme = classNamingScheme;
        this.initTemplate();
    }

    private void initTemplate() {
        String name;
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        if (StringUtils.isNotBlank((String)this.config.getCustomVmTemplate())) {
            props.put("resource.loader", "class, file");
            props.put("file.resource.loader.path", this.config.getProjectBasedir().getAbsolutePath());
            name = this.config.getCustomVmTemplate();
        } else {
            name = this.config.useTestNG() ? "cucumber-testng-runner.java.vm" : "cucumber-junit-runner.java.vm";
        }
        VelocityEngine engine = new VelocityEngine(props);
        engine.init();
        this.velocityTemplate = engine.getTemplate(name, this.config.getEncoding());
    }

    @Override
    public void generateCucumberITFiles(File outputDirectory, Collection<File> featureFiles) throws MojoExecutionException {
        Parser parser = new Parser((Parser.Builder)new AstBuilder());
        Feature feature = null;
        for (File file : featureFiles) {
            try {
                feature = (Feature)parser.parse((Reader)new FileReader(file), (Parser.ITokenMatcher)new TokenMatcher());
            }
            catch (FileNotFoundException e) {
                System.out.println(String.format("WARNING: Failed to parse '%s'...IGNORING", file.getName()));
            }
            if (this.shouldSkipFeature(feature)) continue;
            this.outputFileName = this.classNamingScheme.generate(file.getName());
            this.setFeatureFileLocation(file);
            this.writeFile(outputDirectory);
        }
    }

    private void writeFile(File outputDirectory) throws MojoExecutionException {
        File outputFile = new File(outputDirectory, this.outputFileName + ".java");
        FileWriter w = null;
        try {
            w = new FileWriter(outputFile);
            this.writeContentFromTemplate(w);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + outputFile, (Exception)e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    System.out.println("Failed to close file: " + outputFile);
                }
            }
        }
        ++this.fileCounter;
    }

    private boolean shouldSkipFeature(Feature feature) {
        TagFilter tagFilter;
        return this.config.filterFeaturesByTags() && (tagFilter = new TagFilter(this.overriddenParameters.getTags())).matchingScenariosAndExamples(feature).isEmpty();
    }

    private void setFeatureFileLocation(File file) {
        this.featureFileLocation = CucumberITGeneratorByFeature.normalizePathSeparator(file);
    }

    private static String normalizePathSeparator(File file) {
        return file.getPath().replace(File.separatorChar, '/');
    }

    private void writeContentFromTemplate(Writer writer) {
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)new EscapeJavaReference());
        VelocityContext context = new VelocityContext();
        context.attachEventCartridge(ec);
        context.put("strict", (Object)this.overriddenParameters.isStrict());
        context.put("featureFile", (Object)this.featureFileLocation);
        context.put("plugins", this.createPluginStrings());
        context.put("tags", this.overriddenParameters.getTags());
        context.put("monochrome", (Object)this.overriddenParameters.isMonochrome());
        context.put("cucumberOutputDir", (Object)CucumberITGeneratorByFeature.normalizePathSeparator(this.config.getCucumberOutputDir()));
        context.put("glue", this.overriddenParameters.getGlue());
        context.put("className", (Object)FilenameUtils.removeExtension((String)this.outputFileName));
        context.put("packageName", (Object)this.config.getPackageName());
        this.velocityTemplate.merge((Context)context, writer);
    }

    private List<String> createPluginStrings() {
        ArrayList<String> formatList = new ArrayList<String>();
        for (Plugin plugin : this.overriddenParameters.getPlugins()) {
            formatList.add(plugin.asPluginString(this.fileCounter));
        }
        return formatList;
    }

    private static final class EscapeJavaReference
    implements ReferenceInsertionEventHandler {
        private EscapeJavaReference() {
        }

        public Object referenceInsert(String reference, Object value) {
            if (value == null) {
                return null;
            }
            return StringEscapeUtils.escapeJava((String)value.toString());
        }
    }
}

