/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.CucumberITGenerator;
import com.github.timm.cucumber.generate.CucumberITGeneratorFactory;
import com.github.timm.cucumber.generate.FileGeneratorConfig;
import com.github.timm.cucumber.generate.OverriddenCucumberOptionsParameters;
import com.github.timm.cucumber.generate.ParallelScheme;
import com.github.timm.cucumber.generate.Plugin;
import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import com.github.timm.cucumber.generate.name.ClassNamingSchemeFactory;
import com.github.timm.cucumber.generate.name.OneUpCounter;
import com.github.timm.cucumber.options.RuntimeOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generateRunners", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class GenerateRunnersMojo
extends AbstractMojo
implements FileGeneratorConfig {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="cucumber.glue", required=true)
    private List<String> glue;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/cucumber", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/cucumber-parallel", property="cucumberOutputDir", required=true)
    private File cucumberOutputDir;
    @Parameter(defaultValue="src/test/resources/features/", property="featuresDir", required=true)
    private File featuresDirectory;
    @Parameter(defaultValue="true", property="cucumber.strict", required=true)
    private boolean strict;
    @Parameter(defaultValue="json", property="cucumber.format", required=true)
    private String format;
    @Parameter
    private List<Plugin> plugins;
    @Parameter(defaultValue="false", property="cucumber.monochrome", required=true)
    private boolean monochrome;
    @Parameter(property="cucumber.tags", required=false)
    private List<String> tags;
    @Parameter(defaultValue="UTF-8", property="project.build.sourceEncoding", readonly=true)
    private String encoding;
    @Parameter(defaultValue="false", property="useTestNG", required=true)
    private boolean useTestNG;
    @Parameter(property="cucumber.options", required=false)
    private String cucumberOptions;
    @Parameter(defaultValue="simple", property="namingScheme", required=false)
    private String namingScheme;
    @Parameter(property="namingPattern", required=false)
    private String namingPattern;
    @Parameter(property="packageName", required=false)
    private String packageName;
    @Parameter(defaultValue="FEATURE", property="parallelScheme", required=true)
    private ParallelScheme parallelScheme;
    @Parameter(property="customVmTemplate", required=false)
    private String customVmTemplate;

    public void execute() throws MojoExecutionException {
        File packageDirectory;
        if (!this.featuresDirectory.exists()) {
            throw new MojoExecutionException("Features directory does not exist");
        }
        Collection featureFiles = FileUtils.listFiles((File)this.featuresDirectory, (String[])new String[]{"feature"}, (boolean)true);
        List sortedFeatureFiles = new NameFileComparator().sort(new ArrayList(featureFiles));
        this.createOutputDirIfRequired();
        File file = packageDirectory = this.packageName == null ? this.outputDirectory : new File(this.outputDirectory, this.packageName.replace('.', '/'));
        if (!packageDirectory.exists()) {
            packageDirectory.mkdirs();
        }
        CucumberITGenerator fileGenerator = this.createFileGenerator();
        fileGenerator.generateCucumberITFiles(packageDirectory, sortedFeatureFiles);
        this.getLog().info((CharSequence)("Adding " + this.outputDirectory.getAbsolutePath() + " to test-compile source root"));
        this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private CucumberITGenerator createFileGenerator() throws MojoExecutionException {
        OverriddenCucumberOptionsParameters overriddenParameters = this.overrideParametersWithCucumberOptions();
        ClassNamingSchemeFactory factory = new ClassNamingSchemeFactory(new OneUpCounter());
        ClassNamingScheme classNamingScheme = factory.create(this.namingScheme, this.namingPattern);
        return new CucumberITGeneratorFactory(this, overriddenParameters, classNamingScheme).create(this.parallelScheme);
    }

    private void createOutputDirIfRequired() {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    private OverriddenCucumberOptionsParameters overrideParametersWithCucumberOptions() throws MojoExecutionException {
        try {
            OverriddenCucumberOptionsParameters overriddenParameters = new OverriddenCucumberOptionsParameters().setTags(this.tags).setGlue(this.glue).setStrict(this.strict).setPlugins(this.parseFormatAndPlugins(this.format, this.plugins == null ? new ArrayList() : this.plugins)).setMonochrome(this.monochrome);
            if (this.cucumberOptions != null && this.cucumberOptions.length() > 0) {
                RuntimeOptions options = new RuntimeOptions(this.cucumberOptions);
                overriddenParameters.overrideTags(options.getFilters()).overrideGlue(options.getGlue()).overridePlugins(this.parsePlugins(options.getPluginNames())).overrideStrict(options.isStrict()).overrideMonochrome(options.isMonochrome());
            }
            return overriddenParameters;
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException((Object)this, "Invalid parameter. ", e.getMessage());
        }
    }

    private List<Plugin> parsePlugins(List<String> pluginStrings) throws MojoExecutionException {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String pluginString : pluginStrings) {
            try {
                plugins.add(Plugin.createBuildInPlugin(pluginString));
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException((Object)this, "Invalid plugin in cucumber.options", "Cucumber options only supports build in plugins. '" + pluginString + "' is not supported as a commandline option, " + "try it as a plugin in the pom?");
            }
        }
        for (Plugin plugin : plugins) {
            plugin.applyDefaults(this.cucumberOutputDir);
        }
        return plugins;
    }

    private List<Plugin> parseFormatAndPlugins(String formats, List<Plugin> plugins) throws MojoExecutionException {
        if (!"json".equals(formats)) {
            this.getLog().warn((CharSequence)"The format parameter is deprecated. Please use plugins");
            for (String format : formats.split(",")) {
                try {
                    plugins.add(Plugin.createBuildInPlugin(format));
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Format '" + format + "' is not supported as a " + "format, try it as a plugin?", (Exception)e);
                }
            }
        }
        if (plugins.isEmpty()) {
            plugins.add(Plugin.createBuildInPlugin("json"));
        }
        for (Plugin plugin : plugins) {
            plugin.applyDefaults(this.cucumberOutputDir);
        }
        return plugins;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public File getCucumberOutputDir() {
        return this.cucumberOutputDir;
    }

    @Override
    public boolean useTestNG() {
        return this.useTestNG;
    }

    @Override
    public String getCustomVmTemplate() {
        return this.customVmTemplate;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public File getProjectBasedir() {
        return this.project.getBasedir();
    }
}

