/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.jpa.AbstractJpaVisitor;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCriteriaQueryVisitor<T>
extends AbstractJpaVisitor<CriteriaQuery<T>, T>
implements RSQLVisitor<CriteriaQuery<T>, EntityManager> {
    private static final Logger LOG = Logger.getLogger(JpaCriteriaQueryVisitor.class.getName());
    private final JpaPredicateVisitor<T> predicateVisitor;

    public JpaCriteriaQueryVisitor(T ... t) {
        super(t);
        this.predicateVisitor = new JpaPredicateVisitor<T>(t);
    }

    protected JpaPredicateVisitor<T> getPredicateVisitor() {
        this.predicateVisitor.setBuilderTools(this.getBuilderTools());
        return this.predicateVisitor;
    }

    public CriteriaQuery<T> visit(AndNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for AndNode: {0}", node);
        CriteriaQuery criteria = entityManager.getCriteriaBuilder().createQuery(this.entityClass);
        Root root = criteria.from(this.entityClass);
        return criteria.where((Expression)this.getPredicateVisitor().defineRoot((From)root).visit(node, entityManager));
    }

    public CriteriaQuery<T> visit(OrNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for OrNode: {0}", node);
        CriteriaQuery criteria = entityManager.getCriteriaBuilder().createQuery(this.entityClass);
        Root root = criteria.from(this.entityClass);
        return criteria.where((Expression)this.getPredicateVisitor().defineRoot((From)root).visit(node, entityManager));
    }

    public CriteriaQuery<T> visit(ComparisonNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for ComparisonNode: {0}", node);
        CriteriaQuery criteria = entityManager.getCriteriaBuilder().createQuery(this.entityClass);
        Root root = criteria.from(this.entityClass);
        return criteria.where((Expression)this.getPredicateVisitor().defineRoot((From)root).visit(node, entityManager));
    }
}

