/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpserver;

import com.github.terma.javaniotcpserver.TcpServerConfig;
import com.github.terma.javaniotcpserver.TcpServerHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

class TcpServerAcceptor
implements TcpServerHandler {
    private static final int ACCEPT_BUFFER_SIZE = 1000;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final TcpServerConfig config;
    private final Queue<TcpServerHandler> handlers;

    public TcpServerAcceptor(TcpServerConfig config, Queue<TcpServerHandler> handlers) {
        this.config = config;
        this.handlers = handlers;
    }

    @Override
    public void register(Selector selector) {
        block2: {
            try {
                ServerSocketChannel server = ServerSocketChannel.open();
                server.socket().bind(new InetSocketAddress(this.config.getPort()), 1000);
                server.configureBlocking(false);
                server.register(selector, 16, this);
            }
            catch (IOException exception) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, "Can't init server connection!", exception);
            }
        }
    }

    @Override
    public void process(SelectionKey key) {
        block3: {
            if (key.isValid() && key.isAcceptable()) {
                try {
                    ServerSocketChannel server = (ServerSocketChannel)key.channel();
                    SocketChannel clientChannel = server.accept();
                    this.handlers.add(this.config.getHandlerFactory().create(clientChannel));
                }
                catch (IOException exception) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, "Can't accept client connection!", exception);
                }
            }
        }
    }

    @Override
    public void destroy() {
    }
}

