/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpproxy;

import com.github.terma.javaniotcpproxy.TcpProxyBuffer;
import com.github.terma.javaniotcpproxy.TcpProxyConfig;
import com.github.terma.javaniotcpserver.TcpServerHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

class TcpProxyConnector
implements TcpServerHandler {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final TcpProxyBuffer clientBuffer = new TcpProxyBuffer();
    private final TcpProxyBuffer serverBuffer = new TcpProxyBuffer();
    private final SocketChannel clientChannel;
    private Selector selector;
    private SocketChannel serverChannel;
    private TcpProxyConfig config;

    public TcpProxyConnector(SocketChannel clientChannel, TcpProxyConfig config) {
        this.clientChannel = clientChannel;
        this.config = config;
    }

    public void readFromClient() throws IOException {
        this.serverBuffer.writeFrom(this.clientChannel);
        if (this.serverBuffer.isReadyToRead()) {
            this.register();
        }
    }

    public void readFromServer() throws IOException {
        this.clientBuffer.writeFrom(this.serverChannel);
        if (this.clientBuffer.isReadyToRead()) {
            this.register();
        }
    }

    public void writeToClient() throws IOException {
        this.clientBuffer.writeTo(this.clientChannel);
        if (this.clientBuffer.isReadyToWrite()) {
            this.register();
        }
    }

    public void writeToServer() throws IOException {
        this.serverBuffer.writeTo(this.serverChannel);
        if (this.serverBuffer.isReadyToWrite()) {
            this.register();
        }
    }

    public void register() throws ClosedChannelException {
        int clientOps = 0;
        if (this.serverBuffer.isReadyToWrite()) {
            clientOps |= 1;
        }
        if (this.clientBuffer.isReadyToRead()) {
            clientOps |= 4;
        }
        this.clientChannel.register(this.selector, clientOps, this);
        int serverOps = 0;
        if (this.clientBuffer.isReadyToWrite()) {
            serverOps |= 1;
        }
        if (this.serverBuffer.isReadyToRead()) {
            serverOps |= 4;
        }
        this.serverChannel.register(this.selector, serverOps, this);
    }

    private static void closeQuietly(SocketChannel channel) {
        block3: {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException exception) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                    LOGGER.log(Level.WARNING, "Could not close channel properly.", exception);
                }
            }
        }
    }

    @Override
    public void register(Selector selector) {
        block2: {
            this.selector = selector;
            try {
                this.clientChannel.configureBlocking(false);
                InetSocketAddress socketAddress = new InetSocketAddress(this.config.getRemoteHost(), this.config.getRemotePort());
                this.serverChannel = SocketChannel.open();
                this.serverChannel.connect(socketAddress);
                this.serverChannel.configureBlocking(false);
                this.register();
            }
            catch (IOException exception) {
                this.destroy();
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.log(Level.WARNING, "Could not connect to " + this.config.getRemoteHost() + ":" + this.config.getRemotePort(), exception);
            }
        }
    }

    @Override
    public void process(SelectionKey key) {
        block10: {
            try {
                if (key.channel() == this.clientChannel) {
                    if (key.isValid() && key.isReadable()) {
                        this.readFromClient();
                    }
                    if (key.isValid() && key.isWritable()) {
                        this.writeToClient();
                    }
                }
                if (key.channel() == this.serverChannel) {
                    if (key.isValid() && key.isReadable()) {
                        this.readFromServer();
                    }
                    if (key.isValid() && key.isWritable()) {
                        this.writeToServer();
                    }
                }
            }
            catch (ClosedChannelException exception) {
                this.destroy();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Channel was closed by client or server.", exception);
                }
            }
            catch (IOException exception) {
                this.destroy();
                if (!LOGGER.isLoggable(Level.WARNING)) break block10;
                LOGGER.log(Level.WARNING, "Could not process.", exception);
            }
        }
    }

    @Override
    public void destroy() {
        TcpProxyConnector.closeQuietly(this.clientChannel);
        TcpProxyConnector.closeQuietly(this.serverChannel);
    }
}

