/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpserver;

import com.github.terma.javaniotcpserver.TcpServerAcceptor;
import com.github.terma.javaniotcpserver.TcpServerConfig;
import com.github.terma.javaniotcpserver.TcpServerHandler;
import com.github.terma.javaniotcpserver.TcpServerWorker;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpServer {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final TcpServerConfig config;
    private final String name;
    private Queue<TcpServerHandler> handlers;
    private Thread[] workers;

    public TcpServer(TcpServerConfig config) {
        if (config == null) {
            throw new NullPointerException("Please specify config! Thx!");
        }
        this.config = config;
        this.name = "TcpServer on port " + config.getPort();
    }

    public void start() {
        if (this.workers != null) {
            throw new UnsupportedOperationException("Please shutdown connector!");
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting " + this.name + " with " + this.config.getWorkerCount() + " workers");
        }
        this.handlers = new ConcurrentLinkedQueue<TcpServerHandler>();
        this.handlers.add(new TcpServerAcceptor(this.config, this.handlers));
        this.workers = new Thread[this.config.getWorkerCount()];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new TcpServerWorker(this.handlers);
        }
        for (Thread worker : this.workers) {
            worker.start();
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this.name + " started");
        }
    }

    public void shutdown() {
        TcpServerHandler handler;
        if (this.workers == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(this.name + " already been shutdown");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting shutdown " + this.name);
        }
        for (Thread worker : this.workers) {
            worker.interrupt();
            try {
                worker.join();
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
        this.workers = null;
        while ((handler = this.handlers.poll()) != null) {
            handler.destroy();
        }
        this.handlers = null;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(this.name + " was shutdown");
        }
    }
}

