/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.javaniotcpserver;

import com.github.terma.javaniotcpserver.TcpServerHandler;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class TcpServerWorker
extends Thread {
    private static final long SELECTOR_TIMEOUT = 100L;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final Queue<TcpServerHandler> handlers;

    public TcpServerWorker(Queue<TcpServerHandler> handlers) {
        super("TcpServerWorker");
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Selector selector = null;
        try {
            selector = Selector.open();
            while (!Thread.interrupted()) {
                TcpServerHandler newHandler = this.handlers.poll();
                if (newHandler != null) {
                    newHandler.register(selector);
                }
                selector.select(100L);
                Set<SelectionKey> keys = selector.selectedKeys();
                for (SelectionKey key : keys) {
                    TcpServerHandler handler = (TcpServerHandler)key.attachment();
                    handler.process(key);
                }
                keys.clear();
            }
        }
        catch (IOException exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Problem with selector, worker will be stopped!", exception);
            }
        }
        finally {
            if (selector != null) {
                this.closeSelector(selector);
            }
        }
    }

    private void closeSelector(Selector selector) {
        for (SelectionKey key : selector.keys()) {
            this.closeOrLog(key.channel(), "Could not close selector channel properly.");
        }
        this.closeOrLog(selector, "Could not close selector properly.");
    }

    private void closeOrLog(Closeable closeable, String errorMessage) {
        block2: {
            try {
                closeable.close();
            }
            catch (IOException exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.log(Level.WARNING, errorMessage, exception);
            }
        }
    }
}

