/*
 * Decompiled with CFR 0.152.
 */
package com.github.terrakok.cicerone.androidx;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.github.terrakok.cicerone.Back;
import com.github.terrakok.cicerone.BackTo;
import com.github.terrakok.cicerone.Command;
import com.github.terrakok.cicerone.Forward;
import com.github.terrakok.cicerone.Navigator;
import com.github.terrakok.cicerone.Replace;
import com.github.terrakok.cicerone.Screen;
import com.github.terrakok.cicerone.androidx.ActivityScreen;
import com.github.terrakok.cicerone.androidx.FragmentScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001d\u0010\u001d\u001a\u00020\u00192\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u0019H\u0014J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0019H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010&\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010&\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020\u0019H\u0002J\u001c\u0010/\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\u00100\u001a\u000601j\u0002`2H\u0014J\u0010\u00103\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u000206H\u0014J*\u00107\u001a\u00020\u00192\u0006\u0010&\u001a\u00020+2\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020;H\u0014J\u0018\u0010=\u001a\u00020\u00192\u0006\u0010&\u001a\u00020)2\u0006\u0010>\u001a\u00020?H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006@"}, d2={"Lcom/github/terrakok/cicerone/androidx/AppNavigator;", "Lcom/github/terrakok/cicerone/Navigator;", "activity", "Landroidx/fragment/app/FragmentActivity;", "containerId", "", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "fragmentFactory", "Landroidx/fragment/app/FragmentFactory;", "(Landroidx/fragment/app/FragmentActivity;ILandroidx/fragment/app/FragmentManager;Landroidx/fragment/app/FragmentFactory;)V", "getActivity", "()Landroidx/fragment/app/FragmentActivity;", "getContainerId", "()I", "getFragmentFactory", "()Landroidx/fragment/app/FragmentFactory;", "getFragmentManager", "()Landroidx/fragment/app/FragmentManager;", "localStackCopy", "", "", "getLocalStackCopy", "()Ljava/util/List;", "activityBack", "", "applyCommand", "command", "Lcom/github/terrakok/cicerone/Command;", "applyCommands", "commands", "", "([Lcom/github/terrakok/cicerone/Command;)V", "back", "backTo", "Lcom/github/terrakok/cicerone/BackTo;", "backToRoot", "backToUnexisting", "screen", "Lcom/github/terrakok/cicerone/Screen;", "checkAndStartActivity", "Lcom/github/terrakok/cicerone/androidx/ActivityScreen;", "commitNewFragmentScreen", "Lcom/github/terrakok/cicerone/androidx/FragmentScreen;", "addToBackStack", "", "copyStackToLocal", "errorOnApplyCommand", "error", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "forward", "Lcom/github/terrakok/cicerone/Forward;", "replace", "Lcom/github/terrakok/cicerone/Replace;", "setupFragmentTransaction", "fragmentTransaction", "Landroidx/fragment/app/FragmentTransaction;", "currentFragment", "Landroidx/fragment/app/Fragment;", "nextFragment", "unexistingActivity", "activityIntent", "Landroid/content/Intent;", "cicerone"})
public class AppNavigator
implements Navigator {
    @NotNull
    private final FragmentActivity activity;
    private final int containerId;
    @NotNull
    private final FragmentManager fragmentManager;
    @NotNull
    private final FragmentFactory fragmentFactory;
    @NotNull
    private final List<String> localStackCopy;

    @JvmOverloads
    public AppNavigator(@NotNull FragmentActivity activity, int containerId, @NotNull FragmentManager fragmentManager, @NotNull FragmentFactory fragmentFactory) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)fragmentFactory, (String)"fragmentFactory");
        this.activity = activity;
        this.containerId = containerId;
        this.fragmentManager = fragmentManager;
        this.fragmentFactory = fragmentFactory;
        boolean bl = false;
        this.localStackCopy = new ArrayList();
    }

    public /* synthetic */ AppNavigator(FragmentActivity fragmentActivity, int n, FragmentManager fragmentManager, FragmentFactory fragmentFactory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        FragmentManager fragmentManager2;
        if ((n2 & 4) != 0) {
            fragmentManager2 = fragmentActivity.getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager2, (String)"<init>");
            fragmentManager = fragmentManager2;
        }
        if ((n2 & 8) != 0) {
            fragmentManager2 = fragmentManager.getFragmentFactory();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager2, (String)"<init>");
            fragmentFactory = fragmentManager2;
        }
        this(fragmentActivity, n, fragmentManager, fragmentFactory);
    }

    @NotNull
    protected final FragmentActivity getActivity() {
        return this.activity;
    }

    protected final int getContainerId() {
        return this.containerId;
    }

    @NotNull
    protected final FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    @NotNull
    protected final FragmentFactory getFragmentFactory() {
        return this.fragmentFactory;
    }

    @NotNull
    protected final List<String> getLocalStackCopy() {
        return this.localStackCopy;
    }

    @Override
    public void applyCommands(@NotNull Command[] commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        this.fragmentManager.executePendingTransactions();
        this.copyStackToLocal();
        Command[] commandArray = commands;
        int n = 0;
        int n2 = commandArray.length;
        while (n < n2) {
            Command command = commandArray[n];
            ++n;
            try {
                this.applyCommand(command);
            }
            catch (RuntimeException e) {
                this.errorOnApplyCommand(command, e);
            }
        }
    }

    private final void copyStackToLocal() {
        this.localStackCopy.clear();
        int n = 0;
        int n2 = this.fragmentManager.getBackStackEntryCount();
        if (n < n2) {
            do {
                int i = n++;
                String string = this.fragmentManager.getBackStackEntryAt(i).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fragmentManager.getBackStackEntryAt(i).name");
                this.localStackCopy.add(string);
            } while (n < n2);
        }
    }

    protected void applyCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Command command2 = command;
        if (command2 instanceof Forward) {
            this.forward((Forward)command);
        } else if (command2 instanceof Replace) {
            this.replace((Replace)command);
        } else if (command2 instanceof BackTo) {
            this.backTo((BackTo)command);
        } else if (command2 instanceof Back) {
            this.back();
        }
    }

    protected void forward(@NotNull Forward command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Screen screen = command.getScreen();
        if (screen instanceof ActivityScreen) {
            this.checkAndStartActivity((ActivityScreen)screen);
        } else if (screen instanceof FragmentScreen) {
            this.commitNewFragmentScreen((FragmentScreen)screen, true);
        }
    }

    protected void replace(@NotNull Replace command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Screen screen = command.getScreen();
        if (screen instanceof ActivityScreen) {
            this.checkAndStartActivity((ActivityScreen)screen);
            this.activity.finish();
        } else if (screen instanceof FragmentScreen) {
            Collection collection = this.localStackCopy;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.fragmentManager.popBackStack();
                this.localStackCopy.remove(CollectionsKt.getLastIndex(this.localStackCopy));
                this.commitNewFragmentScreen((FragmentScreen)screen, true);
            } else {
                this.commitNewFragmentScreen((FragmentScreen)screen, false);
            }
        }
    }

    protected void back() {
        Collection collection = this.localStackCopy;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.fragmentManager.popBackStack();
            this.localStackCopy.remove(CollectionsKt.getLastIndex(this.localStackCopy));
        } else {
            this.activityBack();
        }
    }

    protected void activityBack() {
        this.activity.finish();
    }

    protected void commitNewFragmentScreen(@NotNull FragmentScreen screen, boolean addToBackStack) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Fragment fragment = screen.createFragment(this.fragmentFactory);
        FragmentTransaction transaction = this.fragmentManager.beginTransaction();
        transaction.setReorderingAllowed(true);
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"transaction");
        this.setupFragmentTransaction(screen, transaction, this.fragmentManager.findFragmentById(this.containerId), fragment);
        if (screen.getClearContainer()) {
            transaction.replace(this.containerId, fragment, screen.getScreenKey());
        } else {
            transaction.add(this.containerId, fragment, screen.getScreenKey());
        }
        if (addToBackStack) {
            transaction.addToBackStack(screen.getScreenKey());
            this.localStackCopy.add(screen.getScreenKey());
        }
        transaction.commit();
    }

    protected void backTo(@NotNull BackTo command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (command.getScreen() == null) {
            this.backToRoot();
        } else {
            int index;
            block6: {
                int n;
                String screenKey = command.getScreen().getScreenKey();
                List<String> $this$indexOfFirst$iv = this.localStackCopy;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String item$iv;
                    String it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)screenKey)) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index != -1) {
                List<String> forRemove = this.localStackCopy.subList(index, this.localStackCopy.size());
                this.fragmentManager.popBackStack(((String)CollectionsKt.first(forRemove)).toString(), 0);
                forRemove.clear();
            } else {
                this.backToUnexisting(command.getScreen());
            }
        }
    }

    private final void backToRoot() {
        this.localStackCopy.clear();
        this.fragmentManager.popBackStack(null, 1);
    }

    protected void setupFragmentTransaction(@NotNull FragmentScreen screen, @NotNull FragmentTransaction fragmentTransaction, @Nullable Fragment currentFragment, @NotNull Fragment nextFragment) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)fragmentTransaction, (String)"fragmentTransaction");
        Intrinsics.checkNotNullParameter((Object)nextFragment, (String)"nextFragment");
    }

    private final void checkAndStartActivity(ActivityScreen screen) {
        Intent activityIntent = screen.createIntent((Context)this.activity);
        try {
            this.activity.startActivity(activityIntent, screen.getStartActivityOptions());
        }
        catch (ActivityNotFoundException e) {
            this.unexistingActivity(screen, activityIntent);
        }
    }

    protected void unexistingActivity(@NotNull ActivityScreen screen, @NotNull Intent activityIntent) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)activityIntent, (String)"activityIntent");
    }

    protected void backToUnexisting(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        this.backToRoot();
    }

    protected void errorOnApplyCommand(@NotNull Command command, @NotNull RuntimeException error) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        throw error;
    }

    @JvmOverloads
    public AppNavigator(@NotNull FragmentActivity activity, int containerId, @NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        this(activity, containerId, fragmentManager, null, 8, null);
    }

    @JvmOverloads
    public AppNavigator(@NotNull FragmentActivity activity, int containerId) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(activity, containerId, null, null, 12, null);
    }
}

