/*
 * Decompiled with CFR 0.152.
 */
package at.pollux.thymeleaf.shiro.processor.attribute;

import at.pollux.thymeleaf.shiro.processor.ShiroFacade;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public class PrincipalAttrProcessor
extends AbstractAttributeTagProcessor {
    private static final String ATTRIBUTE_NAME = "principal";
    private static final int PRECEDENCE = 300;

    public PrincipalAttrProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTRIBUTE_NAME, true, 300, true);
    }

    protected void doProcess(ITemplateContext iTemplateContext, IProcessableElementTag iProcessableElementTag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler iElementTagStructureHandler) {
        String type = iProcessableElementTag.getAttributeValue("type");
        String property = iProcessableElementTag.getAttributeValue("property");
        String text = ShiroFacade.getPrincipalText(type, property);
        String elementCompleteName = iProcessableElementTag.getElementCompleteName();
        IModelFactory modelFactory = iTemplateContext.getModelFactory();
        IModel model = modelFactory.createModel();
        model.add((ITemplateEvent)modelFactory.createOpenElementTag(elementCompleteName));
        model.add((ITemplateEvent)modelFactory.createText((CharSequence)HtmlEscape.escapeHtml5((String)text)));
        model.add((ITemplateEvent)modelFactory.createCloseElementTag(elementCompleteName));
        iElementTagStructureHandler.replaceWith(model, false);
    }
}

