/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;

abstract class BaseAdapterHelper<T> {
    protected SparseArray<View> views;

    BaseAdapterHelper() {
    }

    public <V extends View> V getView(int viewId) {
        return this.retrieveView(viewId);
    }

    public T setText(int viewId, String value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText((CharSequence)value);
        return (T)this;
    }

    public T setImageResource(int viewId, int imageResId) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageResource(imageResId);
        return (T)this;
    }

    public T setBackgroundColor(int viewId, int color) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundColor(color);
        return (T)this;
    }

    public T setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundResource(backgroundRes);
        return (T)this;
    }

    public T setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(textColor);
        return (T)this;
    }

    public T setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.getItemView().getContext().getResources().getColor(textColorRes));
        return (T)this;
    }

    public T setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageDrawable(drawable);
        return (T)this;
    }

    public T setImageUrl(int viewId, String imageUrl) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        Glide.with((Context)view.getContext()).load(imageUrl).into(view);
        return (T)this;
    }

    public T setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageBitmap(bitmap);
        return (T)this;
    }

    public T setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return (T)this;
    }

    public T setVisible(int viewId, boolean visible) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return (T)this;
    }

    public T linkify(int viewId) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return (T)this;
    }

    public T setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return (T)this;
    }

    public T setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return (T)this;
    }

    public T setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setProgress(progress);
        return (T)this;
    }

    public T setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return (T)this;
    }

    public T setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        return (T)this;
    }

    public T setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setRating(rating);
        return (T)this;
    }

    public T setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return (T)this;
    }

    public T setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener);
        return (T)this;
    }

    public T setOnTouchListener(int viewId, View.OnTouchListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnTouchListener(listener);
        return (T)this;
    }

    public T setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnLongClickListener(listener);
        return (T)this;
    }

    public T setTag(int viewId, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(tag);
        return (T)this;
    }

    public T setTag(int viewId, int key, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(key, tag);
        return (T)this;
    }

    public T setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.retrieveView(viewId);
        view.setChecked(checked);
        return (T)this;
    }

    public T setAdapter(int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setAdapter(adapter);
        return (T)this;
    }

    private <V extends View> V retrieveView(int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.getItemView().findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (V)view;
    }

    public abstract View getItemView();
}

