/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import com.pacific.adapter.DataIO;
import com.pacific.adapter.ExpandableAdapterHelper;
import java.util.ArrayList;
import java.util.List;

abstract class BaseExpandableAdapter<T, V, H extends ExpandableAdapterHelper>
extends BaseExpandableListAdapter
implements DataIO<T> {
    protected ArrayList<T> data;
    protected Context context;
    protected final int groupLayoutResId;
    protected final int childLayoutResId;

    public BaseExpandableAdapter(Context context, int groupLayoutResId, int childLayoutResId) {
        this(context, groupLayoutResId, childLayoutResId, null);
    }

    public BaseExpandableAdapter(Context context, int groupLayoutResId, int childLayoutResId, List<T> data) {
        this.data = data == null ? new ArrayList() : new ArrayList<T>(data);
        this.context = context;
        this.groupLayoutResId = groupLayoutResId;
        this.childLayoutResId = childLayoutResId;
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAt(int location, T elem) {
        this.data.add(location, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAll(List<T> elem) {
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAllAt(int location, List<T> elements) {
        this.data.addAll(location, elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void removeAt(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(List<T> list) {
        this.data.removeAll(list);
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        if (this.data != null && this.data.size() > 0) {
            this.data.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void replace(T oldElem, T newElem) {
        this.replaceAt(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void replaceAt(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> elem) {
        if (this.data.size() > 0) {
            this.data.clear();
        }
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public T get(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    @Override
    public ArrayList<T> getAll() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    public int getGroupCount() {
        return this.getSize();
    }

    public int getChildrenCount(int groupPosition) {
        if (groupPosition < this.getGroupCount()) {
            List<V> children = this.getChildren(groupPosition);
            if (children != null) {
                return children.size();
            }
            return 0;
        }
        return 0;
    }

    public T getGroup(int groupPosition) {
        return this.get(groupPosition);
    }

    public V getChild(int groupPosition, int childPosition) {
        if (groupPosition < this.getGroupCount() && childPosition < this.getChildrenCount(groupPosition)) {
            return this.getChildren(groupPosition).get(childPosition);
        }
        return null;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        if (groupPosition < this.getGroupCount()) {
            return childPosition;
        }
        return -1L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        H help = this.getAdapterHelper(groupPosition, -1, convertView, parent);
        T groupItem = this.getGroup(groupPosition);
        this.convertGroupView(isExpanded, help, groupItem);
        return ((ExpandableAdapterHelper)help).getItemView();
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        H help = this.getAdapterHelper(groupPosition, childPosition, convertView, parent);
        V childItem = this.getChild(groupPosition, childPosition);
        this.convertChildView(isLastChild, help, childItem);
        return ((ExpandableAdapterHelper)help).getItemView();
    }

    protected abstract List<V> getChildren(int var1);

    protected abstract void convertGroupView(boolean var1, H var2, T var3);

    protected abstract void convertChildView(boolean var1, H var2, V var3);

    protected abstract H getAdapterHelper(int var1, int var2, View var3, ViewGroup var4);
}

