/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.pacific.adapter.AdapterHelper;
import com.pacific.adapter.DataIO;
import java.util.ArrayList;
import java.util.List;

abstract class BaseAdapter<T, H extends AdapterHelper>
extends android.widget.BaseAdapter
implements DataIO<T> {
    protected final Context context;
    protected final int layoutResId;
    protected final ArrayList<T> data;

    public BaseAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public BaseAdapter(Context context, int layoutResId, List<T> data) {
        this.data = data == null ? new ArrayList() : new ArrayList<T>(data);
        this.context = context;
        this.layoutResId = layoutResId;
    }

    public int getCount() {
        return this.getSize();
    }

    public T getItem(int position) {
        return this.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        H helper = this.getAdapterHelper(position, convertView, parent);
        T item = this.getItem(position);
        this.convert(helper, item);
        return ((AdapterHelper)helper).getItemView();
    }

    public boolean isEnabled(int position) {
        return position < this.data.size();
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAt(int location, T elem) {
        this.data.add(location, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAll(List<T> elements) {
        this.data.addAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAllAt(int location, List<T> elements) {
        this.data.addAll(location, elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void removeAt(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void removeAll(List<T> elements) {
        this.data.removeAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        if (this.data != null && this.data.size() > 0) {
            this.data.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void replace(T oldElem, T newElem) {
        this.replaceAt(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void replaceAt(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> elements) {
        if (this.data.size() > 0) {
            this.data.clear();
        }
        this.data.addAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public T get(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    @Override
    public ArrayList<T> getAll() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    @Override
    public void onEmpty() {
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.getSize() == 0) {
            this.onEmpty();
        }
    }

    protected abstract void convert(H var1, T var2);

    protected abstract H getAdapterHelper(int var1, View var2, ViewGroup var3);
}

