/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.pacific.adapter.DataIO;
import com.pacific.adapter.RecyclerAdapterHelper;
import java.util.ArrayList;
import java.util.List;

abstract class BaseRecyclerAdapter<T, H extends RecyclerAdapterHelper>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements DataIO<T> {
    protected final Context context;
    protected final LayoutInflater layoutInflater;
    protected final int layoutResId;
    protected final ArrayList<T> data;

    public BaseRecyclerAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public BaseRecyclerAdapter(Context context, int layoutResId, List<T> data) {
        this.context = context;
        this.layoutResId = layoutResId;
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.data = data == null ? new ArrayList() : new ArrayList<T>(data);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new RecyclerView.ViewHolder(this.layoutInflater.inflate(this.layoutResId, parent, false)){};
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        H helper = this.getAdapterHelper(holder);
        T item = this.get(position);
        this.convert(helper, item);
    }

    public int getItemCount() {
        return this.getSize();
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAt(int location, T elem) {
        this.data.add(location, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAll(List<T> elements) {
        this.data.addAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAllAt(int location, List<T> elements) {
        this.data.addAll(location, elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
        if (this.getSize() == 0) {
            this.onEmpty();
        }
    }

    @Override
    public void removeAt(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
        if (this.getSize() == 0) {
            this.onEmpty();
        }
    }

    @Override
    public void removeAll(List<T> elements) {
        this.data.removeAll(elements);
        this.notifyDataSetChanged();
        if (this.getSize() == 0) {
            this.onEmpty();
        }
    }

    @Override
    public void clear() {
        if (this.data != null && this.data.size() > 0) {
            this.data.clear();
            this.notifyDataSetChanged();
        }
        this.onEmpty();
    }

    @Override
    public void replace(T oldElem, T newElem) {
        this.replaceAt(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void replaceAt(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> elements) {
        if (this.data.size() > 0) {
            this.data.clear();
        }
        this.data.addAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public T get(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    @Override
    public ArrayList<T> getAll() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    @Override
    public void onEmpty() {
    }

    protected abstract void convert(H var1, T var2);

    protected abstract H getAdapterHelper(RecyclerView.ViewHolder var1);
}

