/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import com.github.therapi.runtimejavadoc.CommentText;
import com.github.therapi.runtimejavadoc.InlineLink;
import com.github.therapi.runtimejavadoc.InlineTag;
import com.github.therapi.runtimejavadoc.InlineValue;

public class CommentFormatter {
    public String format(Comment comment) {
        if (comment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CommentElement e : comment) {
            if (e instanceof CommentText) {
                sb.append(this.renderText((CommentText)e));
                continue;
            }
            if (e instanceof InlineLink) {
                sb.append(this.renderLink((InlineLink)e));
                continue;
            }
            if (e instanceof InlineValue) {
                sb.append(this.renderValue((InlineValue)e));
                continue;
            }
            if (e instanceof InlineTag) {
                sb.append(this.renderTag((InlineTag)e));
                continue;
            }
            sb.append(this.renderUnrecognized(e));
        }
        return sb.toString();
    }

    protected String renderText(CommentText text) {
        return text.getValue();
    }

    protected String renderLink(InlineLink e) {
        return "{@link " + e.getLink() + "}";
    }

    protected String renderValue(InlineValue e) {
        return e.getValue().getReferencedMemberName() == null ? "{@value}" : "{@value " + e.getValue() + "}";
    }

    protected String renderUnrecognized(CommentElement e) {
        return e.toString();
    }

    protected String renderTag(InlineTag e) {
        switch (e.getName()) {
            case "code": {
                return this.renderCode(e);
            }
            case "literal": {
                return this.renderLiteral(e);
            }
        }
        return this.renderUnrecognizedTag(e);
    }

    protected String renderCode(InlineTag e) {
        return "<code>" + this.escapeHtml(e.getValue()) + "</code>";
    }

    protected String renderLiteral(InlineTag e) {
        return this.escapeHtml(e.getValue());
    }

    protected String renderUnrecognizedTag(InlineTag e) {
        return "{@" + e.getName() + " " + e.getValue() + "}";
    }

    protected String escapeHtml(String value) {
        StringBuilder escaped = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                escaped.append("&quot;");
                continue;
            }
            if (c == '&') {
                escaped.append("&amp;");
                continue;
            }
            if (c == '<') {
                escaped.append("&lt;");
                continue;
            }
            if (c == '>') {
                escaped.append("&gt;");
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }
}

