/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal.parser;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import com.github.therapi.runtimejavadoc.CommentText;
import com.github.therapi.runtimejavadoc.InlineLink;
import com.github.therapi.runtimejavadoc.InlineTag;
import com.github.therapi.runtimejavadoc.InlineValue;
import com.github.therapi.runtimejavadoc.Link;
import com.github.therapi.runtimejavadoc.Value;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.internal.parser.LinkParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CommentParser {
    private static final Pattern inlineTag = Pattern.compile("\\{@(\\w+)(?:\\s+([\\w#][^}]+)?)?}");
    private static final Pattern valuePattern = Pattern.compile("^(?:(?<classname>[\\w.]+)#)?#?(?<member>\\w+)$");

    CommentParser() {
    }

    static Comment parse(String owningClass, String commentText) {
        return RuntimeJavadocHelper.isBlank(commentText) ? Comment.createEmpty() : new Comment(CommentParser.parseElements(owningClass, commentText.trim()));
    }

    private static List<CommentElement> parseElements(String owningClass, String commentText) {
        Matcher matcher = inlineTag.matcher(commentText);
        ArrayList<CommentElement> elements = new ArrayList<CommentElement>();
        int pos = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start > pos) {
                elements.add(new CommentText(commentText.substring(pos, start)));
            }
            CommentElement elt = CommentParser.createTagElement(owningClass, matcher.group(1), matcher.group(2));
            elements.add(elt);
            pos = matcher.end();
        }
        if (pos < commentText.length()) {
            elements.add(new CommentText(commentText.substring(pos)));
        }
        return elements;
    }

    private static CommentElement createTagElement(String owningClass, String name, String value) {
        if ("link".equals(name)) {
            return CommentParser.createLinkElement(owningClass, value);
        }
        if ("value".equals(name)) {
            return CommentParser.createValueElement(owningClass, value);
        }
        return new InlineTag(name, value);
    }

    private static InlineValue createValueElement(String owningClass, String value) {
        if (value == null || value.trim().isEmpty()) {
            return new InlineValue(new Value(null, null));
        }
        Matcher linkMatcher = valuePattern.matcher(value);
        if (!linkMatcher.matches()) {
            throw new AssertionError((Object)"Value didn't match regex format");
        }
        String classRef = linkMatcher.group("classname");
        String memberRef = linkMatcher.group("member");
        String effectiveClassName = classRef == null ? owningClass : classRef;
        return new InlineValue(new Value(effectiveClassName, memberRef));
    }

    private static InlineLink createLinkElement(String owningClass, String value) {
        Link javadocLink = LinkParser.createLinkElement(owningClass, value);
        if (javadocLink == null) {
            throw new AssertionError((Object)"Link didn't match regex format");
        }
        return new InlineLink(javadocLink);
    }
}

