/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import com.github.therapi.runtimejavadoc.CommentText;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class JavadocParser {
    private static final Pattern blockSeparator = Pattern.compile("^\\s*@(?=\\S)", 8);
    private static final Pattern whitespace = Pattern.compile("\\s");

    private static Comment parseComment(String s) {
        ArrayList<CommentElement> commentElements = new ArrayList<CommentElement>();
        commentElements.add(new CommentText(s));
        return new Comment(commentElements);
    }

    public static ClassJavadoc parseClassJavadoc(String className, String javadoc, List<MethodJavadoc> methods) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc);
        ArrayList<OtherJavadoc> otherDocs = new ArrayList<OtherJavadoc>();
        for (BlockTag t : parsed.getBlockTags()) {
            otherDocs.add(new OtherJavadoc(t.name, JavadocParser.parseComment(t.value)));
        }
        return new ClassJavadoc(className, JavadocParser.parseComment(parsed.getDescription()), otherDocs, new ArrayList<SeeAlsoJavadoc>(), methods);
    }

    public static MethodJavadoc parseMethodJavadoc(String methodName, List<String> paramTypes, String javadoc) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc);
        ArrayList<OtherJavadoc> otherDocs = new ArrayList<OtherJavadoc>();
        ArrayList<ParamJavadoc> paramDocs = new ArrayList<ParamJavadoc>();
        Comment returns = null;
        for (BlockTag t : parsed.getBlockTags()) {
            if (t.name.equals("param")) {
                String[] paramNameAndComment = whitespace.split(t.value, 2);
                String paramName = paramNameAndComment[0];
                String paramComment = paramNameAndComment.length == 1 ? "" : paramNameAndComment[1];
                paramDocs.add(new ParamJavadoc(paramName, JavadocParser.parseComment(paramComment)));
                continue;
            }
            if (t.name.equals("return")) {
                returns = JavadocParser.parseComment(t.value);
                continue;
            }
            otherDocs.add(new OtherJavadoc(t.name, JavadocParser.parseComment(t.value)));
        }
        return new MethodJavadoc(methodName, paramTypes, JavadocParser.parseComment(parsed.getDescription()), paramDocs, new ArrayList<ThrowsJavadoc>(), otherDocs, returns, new ArrayList<SeeAlsoJavadoc>());
    }

    public static ParsedJavadoc parse(String javadoc) {
        String[] blocks = blockSeparator.split(javadoc);
        ParsedJavadoc result = new ParsedJavadoc();
        result.description = blocks[0].trim();
        for (int i = 1; i < blocks.length; ++i) {
            result.blockTags.add(new BlockTag(blocks[i].trim()));
        }
        return result;
    }

    public static class BlockTag {
        final String name;
        final String value;

        BlockTag(String nameAndValue) {
            String[] s = whitespace.split(nameAndValue, 2);
            this.name = s[0];
            this.value = s.length > 1 ? s[1] : "";
        }

        public String toString() {
            return "@" + this.name + " : " + this.value;
        }
    }

    public static class ParsedJavadoc {
        String description;
        List<BlockTag> blockTags = new ArrayList<BlockTag>();

        public String toString() {
            return "ParsedJavadoc{description='" + this.description + '\'' + ", blockTags=" + this.blockTags + '}';
        }

        public String getDescription() {
            return this.description;
        }

        public List<BlockTag> getBlockTags() {
            return this.blockTags;
        }
    }
}

