/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.JsonJavadocReader;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.Json;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;

public class RuntimeJavadoc {
    private RuntimeJavadoc() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Optional<ClassJavadoc> getJavadoc(Class clazz) {
        return RuntimeJavadoc.getJavadoc(clazz.getName(), clazz);
    }

    public static Optional<ClassJavadoc> getJavadoc(String qualifiedClassName) {
        return RuntimeJavadoc.getJavadoc(qualifiedClassName, RuntimeJavadoc.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ClassJavadoc> getJavadoc(String qualifiedClassName, ClassLoader classLoader) {
        String resourceName = RuntimeJavadoc.getResourceName(qualifiedClassName);
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            Optional<ClassJavadoc> optional = RuntimeJavadoc.parseJavadocResource(qualifiedClassName, is);
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ClassJavadoc> getJavadoc(String qualifiedClassName, Class loader) {
        String resourceName = RuntimeJavadoc.getResourceName(qualifiedClassName);
        try (InputStream is = loader.getResourceAsStream("/" + resourceName);){
            Optional<ClassJavadoc> optional = RuntimeJavadoc.parseJavadocResource(qualifiedClassName, is);
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getResourceName(String qualifiedClassName) {
        return qualifiedClassName.replace(".", "/") + RuntimeJavadocHelper.javadocResourceSuffix();
    }

    private static Optional<ClassJavadoc> parseJavadocResource(String qualifiedClassName, InputStream is) throws IOException {
        if (is == null) {
            return Optional.empty();
        }
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            JsonObject json = Json.parse(r).asObject();
            Optional<ClassJavadoc> optional = JsonJavadocReader.readClassJavadoc(qualifiedClassName, json);
            return optional;
        }
    }

    public static Optional<MethodJavadoc> getJavadoc(Method method) {
        Optional<ClassJavadoc> javadoc = RuntimeJavadoc.getJavadoc(method.getDeclaringClass());
        return javadoc.map(ClassJavadoc::getMethods).flatMap(mDocs -> RuntimeJavadoc.findMethodJavadoc(mDocs, method));
    }

    private static Optional<MethodJavadoc> findMethodJavadoc(List<MethodJavadoc> methodDocs, Method method) {
        return methodDocs.stream().filter(m -> m.matches(method)).findAny();
    }

    public static Optional<FieldJavadoc> getJavadoc(Field field) {
        Optional<ClassJavadoc> javadoc = RuntimeJavadoc.getJavadoc(field.getDeclaringClass());
        return javadoc.map(ClassJavadoc::getFields).flatMap(fDocs -> RuntimeJavadoc.findFieldJavadoc(fDocs, field));
    }

    private static Optional<FieldJavadoc> findFieldJavadoc(List<FieldJavadoc> fieldDocs, Field field) {
        return fieldDocs.stream().filter(m -> m.getName().equals(field.getName())).findAny();
    }

    public static Optional<FieldJavadoc> getJavadoc(Enum<?> enumValue) {
        Optional<ClassJavadoc> javadoc = RuntimeJavadoc.getJavadoc(enumValue.getDeclaringClass());
        return javadoc.map(ClassJavadoc::getEnumConstants).flatMap(fDocs -> RuntimeJavadoc.findEnumValueJavadoc(fDocs, enumValue));
    }

    private static Optional<FieldJavadoc> findEnumValueJavadoc(List<FieldJavadoc> fieldDocs, Enum<?> enumValue) {
        return fieldDocs.stream().filter(m -> m.getName().equals(enumValue.name())).findAny();
    }
}

