/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MethodJavadoc {
    private final String name;
    private final List<String> paramTypes;
    private final Comment comment;
    private final List<ParamJavadoc> params;
    private final List<ThrowsJavadoc> exceptions;
    private final List<OtherJavadoc> other;
    private final Comment returns;
    private final List<SeeAlsoJavadoc> seeAlso;

    public MethodJavadoc(String name, List<String> paramTypes, Comment comment, List<ParamJavadoc> params, List<ThrowsJavadoc> exceptions, List<OtherJavadoc> other, Comment returns, List<SeeAlsoJavadoc> seeAlso) {
        this.name = name;
        this.paramTypes = paramTypes;
        this.comment = comment;
        this.params = RuntimeJavadocHelper.unmodifiableDefensiveCopy(params);
        this.exceptions = RuntimeJavadocHelper.unmodifiableDefensiveCopy(exceptions);
        this.other = RuntimeJavadocHelper.unmodifiableDefensiveCopy(other);
        this.returns = returns;
        this.seeAlso = RuntimeJavadocHelper.unmodifiableDefensiveCopy(seeAlso);
    }

    public boolean matches(Method method) {
        if (!method.getName().equals(this.name)) {
            return false;
        }
        List methodParamsTypes = Arrays.stream(method.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.toList());
        return methodParamsTypes.equals(this.paramTypes);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParamTypes() {
        return this.paramTypes;
    }

    public Comment getComment() {
        return this.comment;
    }

    public List<ParamJavadoc> getParams() {
        return this.params;
    }

    public List<ThrowsJavadoc> getThrows() {
        return this.exceptions;
    }

    public List<OtherJavadoc> getOther() {
        return this.other;
    }

    public Comment getReturns() {
        return this.returns;
    }

    public List<SeeAlsoJavadoc> getSeeAlso() {
        return this.seeAlso;
    }

    public String toString() {
        return "MethodJavadoc{name='" + this.name + '\'' + ", paramTypes='" + this.paramTypes + '\'' + ", comment=" + this.comment + ", params=" + this.params + ", exceptions=" + this.exceptions + ", other=" + this.other + ", returns=" + this.returns + ", seeAlso=" + this.seeAlso + '}';
    }
}

