/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.internal.parser.JavadocParser;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonArray;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class JsonJavadocReader {
    public static Optional<ClassJavadoc> readClassJavadoc(String qualifiedClassName, JsonObject json) {
        String className = qualifiedClassName.replace("$", ".");
        List<FieldJavadoc> fields = JsonJavadocReader.readFieldDocs(json.get(RuntimeJavadocHelper.fieldsFieldName()));
        List<FieldJavadoc> enumConstants = JsonJavadocReader.readFieldDocs(json.get(RuntimeJavadocHelper.enumConstantsFieldName()));
        List<MethodJavadoc> methods = JsonJavadocReader.readMethodDocs(json.get(RuntimeJavadocHelper.methodsFieldName()));
        String classJavadocString = json.getString(RuntimeJavadocHelper.elementDocFieldName(), null);
        ClassJavadoc classJavadoc = JavadocParser.parseClassJavadoc(className, classJavadocString, fields, enumConstants, methods);
        return Optional.of(classJavadoc);
    }

    private static List<FieldJavadoc> readFieldDocs(JsonValue fieldsValue) {
        if (fieldsValue == null) {
            return Collections.emptyList();
        }
        JsonArray fieldsArray = fieldsValue.asArray();
        ArrayList<FieldJavadoc> fields = new ArrayList<FieldJavadoc>(fieldsArray.size());
        for (JsonValue fieldValue : fieldsArray) {
            fields.add(JsonJavadocReader.readFieldDoc(fieldValue));
        }
        return fields;
    }

    private static FieldJavadoc readFieldDoc(JsonValue fieldValue) {
        JsonObject field = fieldValue.asObject();
        String fieldName = field.getString(RuntimeJavadocHelper.elementNameFieldName(), null);
        String fieldDoc = field.getString(RuntimeJavadocHelper.elementDocFieldName(), null);
        return JavadocParser.parseFieldJavadoc(fieldName, fieldDoc);
    }

    private static List<MethodJavadoc> readMethodDocs(JsonValue methodsValue) {
        JsonArray methodArray = methodsValue.asArray();
        ArrayList<MethodJavadoc> methods = new ArrayList<MethodJavadoc>(methodArray.size());
        for (JsonValue methodValue : methodArray) {
            methods.add(JsonJavadocReader.readMethodDoc(methodValue));
        }
        return methods;
    }

    private static MethodJavadoc readMethodDoc(JsonValue methodValue) {
        JsonObject method = methodValue.asObject();
        String methodName = method.getString(RuntimeJavadocHelper.elementNameFieldName(), null);
        List<String> paramTypes = JsonJavadocReader.readParamTypes(method.get(RuntimeJavadocHelper.paramTypesFieldName()));
        String methodDoc = method.getString(RuntimeJavadocHelper.elementDocFieldName(), null);
        return JavadocParser.parseMethodJavadoc(methodName, paramTypes, methodDoc);
    }

    private static List<String> readParamTypes(JsonValue paramTypesValue) {
        JsonArray paramTypesArray = paramTypesValue.asArray();
        ArrayList<String> paramTypes = new ArrayList<String>(paramTypesArray.size());
        for (JsonValue v : paramTypesArray) {
            paramTypes.add(v.asString());
        }
        return paramTypes;
    }
}

